/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.context.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.gui.plugin.menu.GuiMenuItem;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiMenuWidgets;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;

public class MenuContextHandler
implements IGuiContextHandler {
    private static final Class<?> PKG = MenuContextHandler.class;
    public static final String CONTEXT_ID = "HopGuiMenuContext";
    private final String rootMenuId;
    private final GuiMenuWidgets widgets;

    public MenuContextHandler(String rootMenuId, GuiMenuWidgets widgets) {
        this.rootMenuId = rootMenuId;
        this.widgets = widgets;
    }

    @Override
    public String getContextId() {
        return CONTEXT_ID;
    }

    @Override
    public List<GuiAction> getSupportedActions() {
        ArrayList<GuiAction> actions = new ArrayList<GuiAction>();
        GuiRegistry registry = GuiRegistry.getInstance();
        Map guiMenuMap = registry.getGuiMenuMap();
        Map menuMap = (Map)guiMenuMap.get(this.rootMenuId);
        ArrayList<GuiMenuItem> items = new ArrayList<GuiMenuItem>();
        for (String key : menuMap.keySet()) {
            GuiMenuItem parentMenuItem;
            String parentId;
            GuiMenuItem item = (GuiMenuItem)menuMap.get(key);
            Boolean enabled = this.widgets.getMenuEnabledMap().get(item.getId());
            if (enabled != null && !enabled.booleanValue() || (parentId = item.getParentId()) == null || (parentMenuItem = registry.findGuiMenuItem(this.rootMenuId, parentId)) == null) continue;
            items.add(item);
        }
        Collections.sort(items);
        for (GuiMenuItem item : items) {
            GuiMenuItem parentMenuItem;
            String parentId = item.getParentId();
            if (parentId == null || (parentMenuItem = registry.findGuiMenuItem(this.rootMenuId, parentId)) == null) continue;
            GuiAction action = new GuiAction(item.getId(), GuiActionType.Custom, item.getLabel().replace("&", ""), item.getToolTip(), Const.NVL((String)item.getImage(), (String)"ui/images/logo_bw.svg"), (shiftClicked, controlClicked, parameters) -> {
                try {
                    GuiMenuWidgets.executeMenuItem(item, this.widgets.getInstanceId());
                }
                catch (Exception e) {
                    new ErrorDialog(HopGui.getInstance().getShell(), "Error", "There was an error executing menu item " + item.getId(), e);
                }
            });
            action.setClassLoader(item.getClassLoader());
            action.setCategory(parentMenuItem.getLabel().replace("&", ""));
            action.setCategoryOrder(parentMenuItem.getId());
            actions.add(action);
        }
        return actions;
    }

    public String getRootMenuId() {
        return this.rootMenuId;
    }

    public GuiMenuWidgets getWidgets() {
        return this.widgets;
    }
}

