/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class PrefetchableIterators {
    private static final @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<@UnknownKeyFor @NonNull @Initialized Object> EMPTY_ITERATOR = new PrefetchableIterator<Object>(){

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isReady() {
            return true;
        }

        @Override
        public void prefetch() {
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            return false;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object next() {
            throw new NoSuchElementException();
        }
    };

    public static <T> @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> fromArray(final T ... values) {
        if (values.length == 0) {
            return PrefetchableIterators.emptyIterator();
        }
        return new PrefetchableIterator<T>(){
            @UnknownKeyFor @NonNull @Initialized int currentIndex;

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean isReady() {
                return true;
            }

            @Override
            public void prefetch() {
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                return this.currentIndex < values.length;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return values[this.currentIndex++];
            }
        };
    }

    static <T> @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> maybePrefetchable(final @UnknownKeyFor @NonNull @Initialized Iterator<T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("Expected non-null iterator.");
        }
        if (iterator instanceof PrefetchableIterator) {
            return (PrefetchableIterator)iterator;
        }
        return new PrefetchableIterator<T>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean isReady() {
                return true;
            }

            @Override
            public void prefetch() {
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> concatIterators(final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Iterator<T>> iterators) {
        if (!iterators.hasNext()) {
            return PrefetchableIterators.emptyIterator();
        }
        return new PrefetchableIterator<T>(){
            @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> delegate;
            {
                this.delegate = PrefetchableIterators.maybePrefetchable((Iterator)iterators.next());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean isReady() {
                while (this.delegate.isReady()) {
                    if (this.delegate.hasNext()) {
                        return true;
                    }
                    if (!iterators.hasNext()) {
                        return true;
                    }
                    this.delegate = PrefetchableIterators.maybePrefetchable((Iterator)iterators.next());
                }
                return false;
            }

            @Override
            public void prefetch() {
                if (!this.isReady()) {
                    this.delegate.prefetch();
                }
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                while (!this.delegate.hasNext()) {
                    if (!iterators.hasNext()) {
                        return false;
                    }
                    this.delegate = PrefetchableIterators.maybePrefetchable((Iterator)iterators.next());
                }
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.delegate.next();
            }
        };
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<T> concat(Iterator<T> ... iterators) {
        for (int i = 0; i < iterators.length; ++i) {
            if (iterators[i] != null) continue;
            throw new IllegalArgumentException("Iterator at position " + i + " was null.");
        }
        if (iterators.length == 0) {
            return PrefetchableIterators.emptyIterator();
        }
        if (iterators.length == 1) {
            return PrefetchableIterators.maybePrefetchable(iterators[0]);
        }
        return PrefetchableIterators.concatIterators(Arrays.asList(iterators).iterator());
    }
}

