/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@Internal
public class Preconditions {
    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return reference;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference, @Nullable @UnknownKeyFor @Initialized Object errorMessage) {
        if (reference == null) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return reference;
    }

    @EnsuresNonNull(value={"reference"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])errorMessageArgs));
        }
        return reference;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{Character.valueOf(p1)}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @Nullable @UnknownKeyFor @Initialized Object p1) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{Character.valueOf(p1), Character.valueOf(p2)}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{Character.valueOf(p1), p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{Character.valueOf(p1), p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @Nullable @UnknownKeyFor @Initialized Object p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{Character.valueOf(p1), p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, Character.valueOf(p2)}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @Nullable @UnknownKeyFor @Initialized Object p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, Character.valueOf(p2)}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @Nullable @UnknownKeyFor @Initialized Object p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @Nullable @UnknownKeyFor @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, Character.valueOf(p2)}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @Nullable @UnknownKeyFor @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @Nullable @UnknownKeyFor @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @Nullable @UnknownKeyFor @Initialized Object p1, @Nullable @UnknownKeyFor @Initialized Object p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @Nullable @UnknownKeyFor @Initialized Object p1, @Nullable @UnknownKeyFor @Initialized Object p2, @Nullable @UnknownKeyFor @Initialized Object p3) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2, p3}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @Nullable @UnknownKeyFor @Initialized Object p1, @Nullable @UnknownKeyFor @Initialized Object p2, @Nullable @UnknownKeyFor @Initialized Object p3, @Nullable @UnknownKeyFor @Initialized Object p4) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2, p3, p4}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkStateNotNull(@Nullable T obj) {
        if (obj == null) {
            throw new IllegalStateException();
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkStateNotNull(@Nullable T reference, @Nullable @UnknownKeyFor @Initialized Object errorMessage) {
        if (reference == null) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
        return reference;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkStateNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, Object ... errorMessageArgs) {
        if (obj == null) {
            throw new IllegalStateException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])errorMessageArgs));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkStateNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @Nullable @UnknownKeyFor @Initialized Object p1) {
        if (obj == null) {
            throw new IllegalStateException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @Pure
    @CanIgnoreReturnValue
    public static <T> T checkStateNotNull(@Nullable T obj, @Nullable @UnknownKeyFor @Initialized String errorMessageTemplate, @Nullable @UnknownKeyFor @Initialized Object p1, @Nullable @UnknownKeyFor @Initialized Object p2) {
        if (obj == null) {
            throw new IllegalStateException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }
}

