/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.internal.core.ConsistencyLevelRegistry;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultConsistencyLevelRegistry
implements ConsistencyLevelRegistry {
    private static final ImmutableList<ConsistencyLevel> VALUES = ImmutableList.builder().add((Object[])DefaultConsistencyLevel.values()).build();
    private static final ImmutableMap<String, Integer> NAME_TO_CODE;

    @Override
    public ConsistencyLevel codeToLevel(int code) {
        return DefaultConsistencyLevel.fromCode(code);
    }

    @Override
    public int nameToCode(String name) {
        return (Integer)NAME_TO_CODE.get((Object)name);
    }

    @Override
    public ConsistencyLevel nameToLevel(String name) {
        return DefaultConsistencyLevel.valueOf(name);
    }

    @Override
    public Iterable<ConsistencyLevel> getValues() {
        return VALUES;
    }

    static {
        ImmutableMap.Builder nameToCodeBuilder = ImmutableMap.builder();
        for (DefaultConsistencyLevel consistencyLevel : DefaultConsistencyLevel.values()) {
            nameToCodeBuilder.put((Object)consistencyLevel.name(), (Object)consistencyLevel.getProtocolCode());
        }
        NAME_TO_CODE = nameToCodeBuilder.build();
    }
}

