/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.bootstrap.AsyncServerBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers;
import org.apache.hc.core5.http.nio.entity.DiscardingEntityConsumer;
import org.apache.hc.core5.http.nio.support.AsyncResponseBuilder;
import org.apache.hc.core5.http.nio.support.BasicRequestConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpDateGenerator;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.TimeValue;

public class AsyncFileServerExample {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Please specify document root directory");
            System.exit(1);
        }
        final File docRoot = new File(args[0]);
        int port = 8080;
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        IOReactorConfig config = IOReactorConfig.custom().setSoTimeout(15, TimeUnit.SECONDS).setTcpNoDelay(true).build();
        HttpAsyncServer server = AsyncServerBootstrap.bootstrap().setExceptionCallback(e -> e.printStackTrace()).setIOReactorConfig(config).register("*", (AsyncServerRequestHandler)new AsyncServerRequestHandler<Message<HttpRequest, Void>>(){

            public AsyncRequestConsumer<Message<HttpRequest, Void>> prepare(HttpRequest request, EntityDetails entityDetails, HttpContext context) throws HttpException {
                return new BasicRequestConsumer((AsyncEntityConsumer)(entityDetails != null ? new DiscardingEntityConsumer() : null));
            }

            public void handle(Message<HttpRequest, Void> message, AsyncServerRequestHandler.ResponseTrigger responseTrigger, HttpContext localContext) throws HttpException, IOException {
                URI requestUri;
                HttpCoreContext context = HttpCoreContext.cast((HttpContext)localContext);
                HttpRequest request = (HttpRequest)message.getHead();
                try {
                    requestUri = request.getUri();
                }
                catch (URISyntaxException ex) {
                    throw new ProtocolException(ex.getMessage(), (Throwable)ex);
                }
                String path = requestUri.getPath();
                File file = new File(docRoot, path);
                if (!file.exists()) {
                    String msg = "File " + file.getPath() + " not found";
                    AsyncFileServerExample.println(msg);
                    responseTrigger.submitResponse(AsyncResponseBuilder.create((int)404).setEntity("<html><body><h1>" + msg + "</h1></body></html>", ContentType.TEXT_HTML).build(), (HttpContext)context);
                } else if (!file.canRead() || file.isDirectory()) {
                    String msg = "Cannot read file " + file.getPath();
                    AsyncFileServerExample.println(msg);
                    responseTrigger.submitResponse(AsyncResponseBuilder.create((int)403).setEntity("<html><body><h1>" + msg + "</h1></body></html>", ContentType.TEXT_HTML).build(), (HttpContext)context);
                } else {
                    String filename = TextUtils.toLowerCase((String)file.getName());
                    ContentType contentType = filename.endsWith(".txt") ? ContentType.TEXT_PLAIN : (filename.endsWith(".html") || filename.endsWith(".htm") ? ContentType.TEXT_HTML : (filename.endsWith(".xml") ? ContentType.TEXT_XML : ContentType.DEFAULT_BINARY));
                    EndpointDetails endpoint = context.getEndpointDetails();
                    AsyncFileServerExample.println(endpoint + " | serving file " + file.getPath());
                    responseTrigger.submitResponse(AsyncResponseBuilder.create((int)200).setEntity(AsyncEntityProducers.create((File)file, (ContentType)contentType)).build(), (HttpContext)context);
                }
            }
        }).create();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            AsyncFileServerExample.println("HTTP server shutting down");
            server.close(CloseMode.GRACEFUL);
        }));
        server.start();
        Future future = server.listen((SocketAddress)new InetSocketAddress(port), URIScheme.HTTP);
        ListenerEndpoint listenerEndpoint = (ListenerEndpoint)future.get();
        AsyncFileServerExample.println("Listening on " + listenerEndpoint.getAddress());
        server.awaitShutdown(TimeValue.MAX_VALUE);
    }

    static void println(String msg) {
        System.out.println(HttpDateGenerator.INSTANCE.getCurrentDate() + " | " + msg);
    }
}

