/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.observers.SerializedObserver;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSampleTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Consumer<? super T> onDropped;
    final boolean emitLast;

    public ObservableSampleTimed(ObservableSource<T> source, long period, TimeUnit unit, Scheduler scheduler, boolean emitLast, Consumer<? super T> onDropped) {
        super(source);
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
        this.emitLast = emitLast;
        this.onDropped = onDropped;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        SerializedObserver<? super T> serial = new SerializedObserver<T>(t);
        if (this.emitLast) {
            this.source.subscribe(new SampleTimedEmitLast<T>(serial, this.period, this.unit, this.scheduler, this.onDropped));
        } else {
            this.source.subscribe(new SampleTimedNoLast<T>(serial, this.period, this.unit, this.scheduler, this.onDropped));
        }
    }

    static final class SampleTimedEmitLast<T>
    extends SampleTimedObserver<T> {
        private static final long serialVersionUID = -7139995637533111443L;
        final AtomicInteger wip = new AtomicInteger(1);

        SampleTimedEmitLast(Observer<? super T> actual, long period, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onDropped) {
            super(actual, period, unit, scheduler, onDropped);
        }

        @Override
        void complete() {
            this.emit();
            if (this.wip.decrementAndGet() == 0) {
                this.downstream.onComplete();
            }
        }

        @Override
        public void run() {
            if (this.wip.incrementAndGet() == 2) {
                this.emit();
                if (this.wip.decrementAndGet() == 0) {
                    this.downstream.onComplete();
                }
            }
        }
    }

    static final class SampleTimedNoLast<T>
    extends SampleTimedObserver<T> {
        private static final long serialVersionUID = -7139995637533111443L;

        SampleTimedNoLast(Observer<? super T> actual, long period, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onDropped) {
            super(actual, period, unit, scheduler, onDropped);
        }

        @Override
        void complete() {
            this.downstream.onComplete();
        }

        @Override
        public void run() {
            this.emit();
        }
    }

    static abstract class SampleTimedObserver<T>
    extends AtomicReference<T>
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = -3517602651313910099L;
        final Observer<? super T> downstream;
        final long period;
        final TimeUnit unit;
        final Scheduler scheduler;
        final Consumer<? super T> onDropped;
        final AtomicReference<Disposable> timer = new AtomicReference();
        Disposable upstream;

        SampleTimedObserver(Observer<? super T> actual, long period, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onDropped) {
            this.downstream = actual;
            this.period = period;
            this.unit = unit;
            this.scheduler = scheduler;
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
                Disposable task = this.scheduler.schedulePeriodicallyDirect(this, this.period, this.period, this.unit);
                DisposableHelper.replace(this.timer, task);
            }
        }

        @Override
        public void onNext(T t) {
            T oldValue = this.getAndSet(t);
            if (oldValue != null && this.onDropped != null) {
                try {
                    this.onDropped.accept(oldValue);
                }
                catch (Throwable throwable) {
                    Exceptions.throwIfFatal(throwable);
                    this.cancelTimer();
                    this.upstream.dispose();
                    this.downstream.onError(throwable);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            this.cancelTimer();
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.cancelTimer();
            this.complete();
        }

        void cancelTimer() {
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void dispose() {
            this.cancelTimer();
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                this.downstream.onNext(value);
            }
        }

        abstract void complete();
    }
}

