/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestAsyncEntityProducers {
    TestAsyncEntityProducers() {
    }

    @Test
    void testPathEntityProducer() throws IOException {
        Path path = Paths.get("src/test/resources/test-ssl.txt", new String[0]);
        AsyncEntityProducer producer = AsyncEntityProducers.create((Path)path, (ContentType)ContentType.APPLICATION_OCTET_STREAM, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, LinkOption.NOFOLLOW_LINKS});
        try {
            Assertions.assertFalse((boolean)producer.isChunked());
            Assertions.assertEquals((long)Files.size(path), (long)producer.getContentLength());
            Assertions.assertEquals((Object)ContentType.APPLICATION_OCTET_STREAM.toString(), (Object)producer.getContentType());
        }
        finally {
            producer.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPathEntityProducerWithTrailers() throws IOException {
        Path path = Paths.get("src/test/resources/test-ssl.txt", new String[0]);
        BasicHeader header1 = new BasicHeader("Tailer1", (Object)"Value1");
        BasicHeader header2 = new BasicHeader("Tailer2", (Object)"Value2");
        AsyncEntityProducer producer = AsyncEntityProducers.create((Path)path, (ContentType)ContentType.APPLICATION_OCTET_STREAM, (Header[])new Header[]{header1, header2});
        try {
            Assertions.assertTrue((boolean)producer.isChunked());
            Assertions.assertEquals((long)-1L, (long)producer.getContentLength());
            Assertions.assertEquals((Object)ContentType.APPLICATION_OCTET_STREAM.toString(), (Object)producer.getContentType());
        }
        finally {
            producer.releaseResources();
        }
    }
}

