/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.classic;

import java.io.IOException;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSocket;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.DefaultBHttpClientConnection;
import org.apache.hc.core5.http.impl.io.SocketHolder;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.testing.classic.LoggingSocketHolder;
import org.apache.hc.core5.testing.classic.Wire;
import org.apache.hc.core5.util.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBHttpClientConnection
extends DefaultBHttpClientConnection
implements Identifiable {
    private static final AtomicLong COUNT = new AtomicLong();
    private final String id = "http-outgoing-" + COUNT.incrementAndGet();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Logger headerLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.headers");
    private final Wire wire = new Wire(LoggerFactory.getLogger((String)"org.apache.hc.core5.http.wire"), this.id);

    public LoggingBHttpClientConnection(Http1Config http1Config, CharsetDecoder charDecoder, CharsetEncoder charEncoder, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<ClassicHttpRequest> requestWriterFactory, HttpMessageParserFactory<ClassicHttpResponse> responseParserFactory) {
        super(http1Config, charDecoder, charEncoder, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
    }

    public LoggingBHttpClientConnection(Http1Config http1Config) {
        this(http1Config, null, null, null, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: Close connection", (Object)this.id);
        }
        super.close();
    }

    public void close(CloseMode closeMode) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: Shutdown connection", (Object)this.id);
        }
        super.close(closeMode);
    }

    public void bind(Socket socket) throws IOException {
        super.bind((SocketHolder)(this.wire.isEnabled() ? new LoggingSocketHolder(socket, this.wire) : new SocketHolder(socket)));
    }

    public void bind(SSLSocket sslSocket, Socket baseSocket) throws IOException {
        super.bind((SocketHolder)(this.wire.isEnabled() ? new LoggingSocketHolder(sslSocket, baseSocket, this.wire) : new SocketHolder(sslSocket, baseSocket)));
    }

    protected void onResponseReceived(ClassicHttpResponse response) {
        if (response != null && this.headerLog.isDebugEnabled()) {
            Header[] headers;
            this.headerLog.debug("{} << {}", (Object)this.id, (Object)new StatusLine((HttpResponse)response));
            for (Header header : headers = response.getHeaders()) {
                this.headerLog.debug("{} << {}", (Object)this.id, (Object)header);
            }
        }
    }

    protected void onRequestSubmitted(ClassicHttpRequest request) {
        if (request != null && this.headerLog.isDebugEnabled()) {
            Header[] headers;
            this.headerLog.debug("{} >> {}", (Object)this.id, (Object)new RequestLine((HttpRequest)request));
            for (Header header : headers = request.getHeaders()) {
                this.headerLog.debug("{} >> {}", (Object)this.id, (Object)header);
            }
        }
    }
}

