/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.NullCompleter;
import sqlline.CommandHandler;
import sqlline.SqlLine;

public abstract class AbstractCommandHandler
implements CommandHandler {
    protected final SqlLine sqlLine;
    private final String name;
    private final List<String> names;
    private final String helpText;
    private final List<Completer> parameterCompleters;

    public AbstractCommandHandler(SqlLine sqlLine, String[] names, String helpText, List<Completer> completers) {
        this.sqlLine = sqlLine;
        this.name = names[0];
        this.names = Arrays.asList(names);
        this.helpText = helpText;
        this.parameterCompleters = completers == null || completers.size() == 0 ? Collections.singletonList(new NullCompleter()) : new ArrayList<Completer>(completers);
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String matches(String line) {
        if (line == null || line.length() == 0) {
            return null;
        }
        String[] parts = this.sqlLine.split(line, 1);
        if (parts == null || parts.length == 0) {
            return null;
        }
        for (String name2 : this.names) {
            if (!name2.startsWith(parts[0])) continue;
            return name2;
        }
        return null;
    }

    @Override
    public List<Completer> getParameterCompleters() {
        return this.parameterCompleters;
    }

    @Override
    public boolean echoToFile() {
        return true;
    }
}

