/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import org.apache.ignite.binary.BinaryIdMapper;
import org.apache.ignite.binary.BinaryNameMapper;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.util.typedef.internal.S;

public class BinaryInternalMapper {
    private final BinaryNameMapper nameMapper;
    private final BinaryIdMapper idMapper;
    private boolean checkOnZeroId;

    public BinaryInternalMapper(BinaryNameMapper nameMapper, BinaryIdMapper idMapper, boolean checkOnZeroId) {
        assert (nameMapper != null);
        assert (idMapper != null);
        this.nameMapper = nameMapper;
        this.idMapper = idMapper;
        this.checkOnZeroId = checkOnZeroId;
    }

    public BinaryNameMapper nameMapper() {
        return this.nameMapper;
    }

    public BinaryIdMapper idMapper() {
        return this.idMapper;
    }

    public int typeId(String clsName) {
        int id = this.idMapper.typeId(this.nameMapper.typeName(clsName));
        if (!this.checkOnZeroId) {
            return id;
        }
        return id != 0 ? id : BinaryContext.SIMPLE_NAME_LOWER_CASE_MAPPER.typeId(clsName);
    }

    public int fieldId(int typeId, String fieldName) {
        int id = this.idMapper.fieldId(typeId, this.nameMapper.fieldName(fieldName));
        if (!this.checkOnZeroId) {
            return id;
        }
        return id != 0 ? id : BinaryContext.SIMPLE_NAME_LOWER_CASE_MAPPER.fieldId(typeId, fieldName);
    }

    public String typeName(String clsName) {
        return this.nameMapper.typeName(clsName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryInternalMapper)) {
            return false;
        }
        BinaryInternalMapper mapper = (BinaryInternalMapper)o;
        return this.checkOnZeroId == mapper.checkOnZeroId && this.idMapper.equals(mapper.idMapper) && this.nameMapper.equals(mapper.nameMapper);
    }

    public int hashCode() {
        int res = this.nameMapper.hashCode();
        res = 31 * res + this.idMapper.hashCode();
        res = 31 * res + (this.checkOnZeroId ? 1 : 0);
        return res;
    }

    public String toString() {
        return S.toString(BinaryInternalMapper.class, this);
    }
}

