/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.internal.A;

public class BasicRateLimiter {
    private static final long MAX_IDLE_TIMEOUT = TimeUnit.SECONDS.toNanos(1L);
    private final long startTime = System.nanoTime();
    private final Object mux = new Object();
    private double stableIntervalNanos;
    private long nextFreeTicketNanos;
    private double storedPermits;
    private volatile double rate;

    public BasicRateLimiter(double permitsPerSecond) {
        this.setRate(permitsPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRate(double permitsPerSecond) {
        A.ensure(permitsPerSecond >= 0.0, "Requested permits (" + permitsPerSecond + ") must be non-negative.");
        this.rate = permitsPerSecond;
        if (this.rate == 0.0) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            this.stableIntervalNanos = (double)TimeUnit.SECONDS.toNanos(1L) / permitsPerSecond;
            this.nextFreeTicketNanos = System.nanoTime() - this.startTime;
            this.storedPermits = 0.0;
        }
    }

    public double getRate() {
        return this.rate;
    }

    public boolean isUnlimited() {
        return this.rate == 0.0;
    }

    public void acquire(long permits) throws IgniteInterruptedCheckedException {
        if (this.isUnlimited()) {
            return;
        }
        long nanosToWait = this.reserve(permits);
        try {
            TimeUnit.NANOSECONDS.sleep(nanosToWait);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long reserve(long permits) {
        A.ensure(permits > 0L, "Requested permits (" + permits + ") must be positive");
        Object object = this.mux;
        synchronized (object) {
            long nowNanos = this.resync();
            long momentAvailable = this.nextFreeTicketNanos;
            double storedPermitsToSpend = Math.min((double)permits, this.storedPermits);
            double freshPermits = (double)permits - storedPermitsToSpend;
            this.nextFreeTicketNanos = momentAvailable + (long)(freshPermits * this.stableIntervalNanos);
            this.storedPermits -= storedPermitsToSpend;
            return momentAvailable - nowNanos;
        }
    }

    private long resync() {
        long passed = System.nanoTime() - this.startTime;
        if (passed > this.nextFreeTicketNanos) {
            long idleTime = passed - this.nextFreeTicketNanos;
            this.storedPermits = idleTime > MAX_IDLE_TIMEOUT ? 0.0 : Math.min(this.getRate(), this.storedPermits + (double)idleTime / this.stableIntervalNanos);
            this.nextFreeTicketNanos = passed;
        }
        return passed;
    }
}

