/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.jdbc.JdbcUtils;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class NativeSqlMixedDateInlineBenchmark
extends IgniteAbstractBenchmark {
    private static final String TBL_NAME = NativeSqlMixedDateInlineBenchmark.class.getSimpleName().toUpperCase();
    private static final Pattern DIGIT_PATTERN = Pattern.compile("[0-9]+");
    private long resCount;

    private Integer getGroupNumber(Map<Object, Object> ctx) {
        Matcher matcher;
        long tid = Thread.currentThread().getId();
        Integer cnt = (Integer)ctx.get(tid);
        if (cnt == null && (matcher = DIGIT_PATTERN.matcher(Thread.currentThread().getName())).find()) {
            cnt = Integer.parseInt(matcher.group());
            cnt = cnt + 1;
            ctx.put(tid, cnt);
        }
        return cnt;
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        long insertKey = this.getGroupNumber(ctx) * this.args.range() + NativeSqlMixedDateInlineBenchmark.nextRandom(this.args.range() - 1);
        String insertQry = String.format("INSERT INTO %s VALUES (?, ?, ?, ?)", TBL_NAME);
        SqlFieldsQuery insert1 = new SqlFieldsQuery(insertQry);
        insert1.setArgs(new Object[]{insertKey, new BigDecimal(insertKey + 1L), LocalDate.ofEpochDay(insertKey), insertKey + 2L});
        SqlFieldsQuery insert2 = new SqlFieldsQuery(insertQry);
        insert2.setArgs(new Object[]{++insertKey, new BigDecimal(insertKey + 1L), LocalDate.ofEpochDay(insertKey), insertKey + 2L});
        GridQueryProcessor qryProc = ((IgniteEx)this.ignite()).context().query();
        long selectKey = NativeSqlMixedDateInlineBenchmark.nextRandom(this.args.range());
        SqlFieldsQuery select1 = new SqlFieldsQuery(String.format("select * FROM %s where DATE_COL >= ? and DATE_COL < ? and DEC_COL= ?", TBL_NAME));
        select1.setArgs(new Object[]{LocalDate.ofEpochDay(selectKey), LocalDate.ofEpochDay(selectKey + 1L), selectKey + 1L});
        SqlFieldsQuery select2 = new SqlFieldsQuery(String.format("select * FROM %s where DATE_COL = ? and DEC_COL= ?", TBL_NAME));
        select2.setArgs(new Object[]{LocalDate.ofEpochDay(selectKey), selectKey + 1L});
        SqlFieldsQuery delete1 = new SqlFieldsQuery(String.format("DELETE FROM %s WHERE id = ?", TBL_NAME));
        delete1.setArgs(new Object[]{--insertKey});
        SqlFieldsQuery delete2 = new SqlFieldsQuery(String.format("DELETE FROM %s WHERE DATE_COL = ?", TBL_NAME));
        delete2.setArgs(new Object[]{LocalDate.ofEpochDay(++insertKey)});
        try (FieldsQueryCursor insCur1 = qryProc.querySqlFields(insert1, false);
             FieldsQueryCursor insCur2 = qryProc.querySqlFields(insert2, false);
             FieldsQueryCursor selCur1 = qryProc.querySqlFields(select1, false);
             FieldsQueryCursor selCur2 = qryProc.querySqlFields(select2, false);
             FieldsQueryCursor delCur1 = qryProc.querySqlFields(delete1, false);
             FieldsQueryCursor delCur2 = qryProc.querySqlFields(delete2, false);){
            this.resCount += (long)insCur1.getAll().size();
            this.resCount += (long)insCur2.getAll().size();
            this.resCount += (long)selCur1.getAll().size();
            this.resCount += (long)selCur2.getAll().size();
            this.resCount += (long)delCur1.getAll().size();
            this.resCount += (long)delCur2.getAll().size();
        }
        catch (Exception e) {
            BenchmarkUtils.error((String)"error: ", (Throwable)e);
        }
        return true;
    }

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        JdbcUtils.fillTableWithIdx(cfg, (IgniteEx)this.ignite(), TBL_NAME, this.args.range(), this.args.atomicMode());
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        BenchmarkUtils.println((String)("Summary results: " + this.resCount));
    }
}

