/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.upload;

import java.util.List;
import java.util.Map;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.upload.model.QueryFactory;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class AbstractNativeBenchmark
extends IgniteAbstractBenchmark {
    private long insertRowsCnt;
    protected static final String CACHE_NAME = "SQL_PUBLIC_TEST_UPLOAD";
    protected QueryFactory queries;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.queries = new QueryFactory(this.args.atomicMode());
        this.insertRowsCnt = this.args.upload.uploadRowsCnt();
        this.dropAndCreateTable();
        long warmupRowsCnt = this.args.upload.warmupRowsCnt();
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Starting custom warmup. Uploading " + warmupRowsCnt + " rows."));
        this.upload(warmupRowsCnt);
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Custom warmup finished.");
        this.dropAndCreateTable();
    }

    private void dropAndCreateTable() {
        this.executeNativeSql("DROP TABLE IF EXISTS test_upload;");
        this.executeNativeSql(this.queries.createTable());
        for (int idx = 1; idx <= this.args.upload.indexesCount(); ++idx) {
            this.executeNativeSql(this.queries.createIndex(idx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            long size = this.ignite().cache(CACHE_NAME).sizeLong(new CachePeekMode[0]);
            if (size != this.insertRowsCnt) {
                String msg = "Incorrect cache size: [actual=" + size + ", expected=" + this.insertRowsCnt + "].";
                BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("TearDown: " + msg));
                throw new RuntimeException(msg);
            }
        }
        finally {
            super.tearDown();
        }
    }

    private List<List<?>> executeNativeSql(String qry) {
        return ((IgniteEx)this.ignite()).context().query().querySqlFields(new SqlFieldsQuery(qry), false).getAll();
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        this.upload(this.insertRowsCnt);
        return true;
    }

    protected abstract void upload(long var1);
}

