/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridH2DmlResponse
implements Message,
GridCacheQueryMarshallable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private long reqId;
    @GridToStringInclude
    private long updCnt;
    @GridToStringInclude
    private String err;
    @GridToStringInclude
    @GridDirectTransient
    private Object[] errKeys;
    private byte[] errKeysBytes;

    public GridH2DmlResponse() {
    }

    public GridH2DmlResponse(long reqId, long updCnt, Object[] errKeys, String error) {
        this.reqId = reqId;
        this.updCnt = updCnt;
        this.errKeys = errKeys;
        this.err = error;
    }

    public long requestId() {
        return this.reqId;
    }

    public long updateCounter() {
        return this.updCnt;
    }

    public Object[] errorKeys() {
        return this.errKeys;
    }

    public String error() {
        return this.err;
    }

    public void marshall(Marshaller m) {
        if (this.errKeysBytes != null || this.errKeys == null) {
            return;
        }
        try {
            this.errKeysBytes = U.marshal((Marshaller)m, (Object)this.errKeys);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public void unmarshall(Marshaller m, GridKernalContext ctx) {
        if (this.errKeys != null || this.errKeysBytes == null) {
            return;
        }
        try {
            ClassLoader ldr = U.resolveClassLoader((IgniteConfiguration)ctx.config());
            this.errKeys = m instanceof BinaryMarshaller ? BinaryUtils.rawArrayFromBinary((Object)((BinaryMarshaller)m).binaryMarshaller().unmarshal(this.errKeysBytes, ldr)) : (Object[])U.unmarshal((Marshaller)m, (byte[])this.errKeysBytes, (ClassLoader)ldr);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public String toString() {
        return S.toString(GridH2DmlResponse.class, (Object)this);
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeString("err", this.err)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByteArray("errKeysBytes", this.errKeysBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("reqId", this.reqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeLong("updCnt", this.updCnt)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.err = reader.readString("err");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.errKeysBytes = reader.readByteArray("errKeysBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.reqId = reader.readLong("reqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.updCnt = reader.readLong("updCnt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2DmlResponse.class);
    }

    public short directType() {
        return -56;
    }

    public byte fieldsCount() {
        return 4;
    }

    public void onAckReceived() {
    }
}

