/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientNodeStateBeforeStart;
import org.apache.ignite.internal.client.thin.TcpIgniteClient;
import org.apache.ignite.internal.commandline.CloseableCliCommandInvoker;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.BeforeNodeStartCommand;
import org.apache.ignite.internal.management.api.Command;
import org.apache.ignite.internal.management.api.CommandInvoker;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class CliIgniteClientInvoker<A extends IgniteDataTransferObject>
extends CommandInvoker<A>
implements CloseableCliCommandInvoker {
    private final ClientConfiguration cfg;
    private IgniteClient client;

    public CliIgniteClientInvoker(Command<A, ?> cmd, A arg, ClientConfiguration cfg) {
        super(cmd, arg, null);
        this.cfg = cfg;
    }

    protected GridClientNode defaultNode() {
        String[] addr = this.cfg.getAddresses()[0].split(":");
        String host = addr[0];
        String port = addr[1];
        Collection nodes = this.igniteClient().cluster().nodes();
        return CommandUtils.clusterToClientNode((ClusterNode)((ClusterNode)F.find((Iterable)nodes, (Object)U.oldest((Collection)nodes, null), (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)node -> (node.hostNames().contains(host) || node.addresses().contains(host)) && port.equals(node.attribute("clientListenerPort").toString())})));
    }

    @Nullable
    protected IgniteClient igniteClient() {
        if (this.client == null) {
            if (this.cmd instanceof BeforeNodeStartCommand) {
                this.cfg.setUserAttributes(F.asMap((Object)"ignite.internal.management-client", (Object)Boolean.TRUE.toString()));
                this.cfg.setAutoBinaryConfigurationEnabled(false);
            }
            this.client = Ignition.startClient((ClientConfiguration)this.cfg);
        }
        return this.client;
    }

    @Override
    public String confirmationPrompt() {
        return this.cmd.confirmationPrompt(this.arg);
    }

    @Override
    public <R> R invokeBeforeNodeStart(Consumer<String> printer) throws Exception {
        return (R)((BeforeNodeStartCommand)this.cmd).execute(new GridClientNodeStateBeforeStart(){

            public void stopWarmUp() {
                ((TcpIgniteClient)CliIgniteClientInvoker.this.igniteClient()).stopWarmUp();
            }
        }, this.arg, printer);
    }

    @Override
    public void close() {
        U.closeQuiet((AutoCloseable)this.client);
    }
}

