/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.lang.IgniteInClosure;

public abstract class AbstractDataLeafIO
extends BPlusLeafIO<CacheSearchRow>
implements RowLinkIO {
    public AbstractDataLeafIO(int type, int ver, int itemSize) {
        super(type, ver, itemSize);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, CacheSearchRow row) {
        assert (row.link() != 0L);
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, off, row.link());
        PageUtils.putInt(pageAddr, off += 8, row.hash());
        off += 4;
        if (this.storeCacheId()) {
            assert (row.cacheId() != 0);
            PageUtils.putInt(pageAddr, off, row.cacheId());
        }
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BPlusIO<CacheSearchRow> srcIo, long srcPageAddr, int srcIdx) {
        this.assertPageType(dstPageAddr);
        RowLinkIO rowIo = (RowLinkIO)((Object)srcIo);
        long link = rowIo.getLink(srcPageAddr, srcIdx);
        int hash = rowIo.getHash(srcPageAddr, srcIdx);
        int off = this.offset(dstIdx);
        PageUtils.putLong(dstPageAddr, off, link);
        PageUtils.putInt(dstPageAddr, off += 8, hash);
        off += 4;
        if (this.storeCacheId()) {
            int cacheId = rowIo.getCacheId(srcPageAddr, srcIdx);
            assert (cacheId != 0);
            PageUtils.putInt(dstPageAddr, off, cacheId);
        }
    }

    @Override
    public final CacheSearchRow getLookupRow(BPlusTree<CacheSearchRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        long link = this.getLink(pageAddr, idx);
        int hash = this.getHash(pageAddr, idx);
        int cacheId = this.storeCacheId() ? this.getCacheId(pageAddr, idx) : 0;
        return ((CacheDataTree)tree).rowStore().keySearchRow(cacheId, hash, link);
    }

    @Override
    public final long getLink(long pageAddr, int idx) {
        assert (idx < this.getCount(pageAddr)) : "idx=" + idx + ", cnt=" + this.getCount(pageAddr);
        return PageUtils.getLong(pageAddr, this.offset(idx));
    }

    @Override
    public final int getHash(long pageAddr, int idx) {
        return PageUtils.getInt(pageAddr, this.offset(idx) + 8);
    }

    @Override
    public void visit(long pageAddr, IgniteInClosure<CacheSearchRow> c) {
        this.assertPageType(pageAddr);
        int cnt = this.getCount(pageAddr);
        for (int i = 0; i < cnt; ++i) {
            c.apply(new CacheDataRowAdapter(this.getLink(pageAddr, i)));
        }
    }

    public boolean storeCacheId() {
        return false;
    }
}

