/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRoute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface UriRouteMatch<T, R>
extends UriMatchInfo,
MethodBasedRouteMatch<T, R> {
    public UriRoute getRoute();

    default public List<Argument> getRequiredArguments() {
        Object[] arguments = this.getArguments();
        if (ArrayUtils.isNotEmpty((Object[])arguments)) {
            Map matchVariables = this.getVariableValues();
            ArrayList<Argument> actualArguments = new ArrayList<Argument>(arguments.length);
            for (Object argument : arguments) {
                if (matchVariables.containsKey(argument.getName())) continue;
                actualArguments.add((Argument)argument);
            }
            return actualArguments;
        }
        return Collections.emptyList();
    }

    public HttpMethod getHttpMethod();

    public UriRouteMatch<T, R> fulfill(Map<String, Object> var1);

    public UriRouteMatch<T, R> decorate(Function<RouteMatch<R>, R> var1);
}

