/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.registry.impl;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.call.cluster.unit.ClusterListUnitCall;
import org.apache.ignite.internal.cli.call.unit.ListUnitCallInput;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.internal.cli.core.repl.registry.UnitsRegistry;
import org.apache.ignite.internal.cli.core.repl.registry.impl.LazyObjectRef;
import org.apache.ignite.internal.cli.event.ConnectionEventListener;
import org.apache.ignite.rest.client.model.UnitStatus;
import org.apache.ignite.rest.client.model.UnitVersionStatus;

@Singleton
public class UnitsRegistryImpl
implements UnitsRegistry,
ConnectionEventListener {
    private final AtomicReference<String> lastKnownUrl = new AtomicReference<Object>(null);
    private final ClusterListUnitCall call;
    private LazyObjectRef<Map<String, Set<String>>> idToVersionsRef;

    public UnitsRegistryImpl(ClusterListUnitCall call) {
        this.call = call;
    }

    @Override
    public void onConnect(SessionInfo sessionInfo) {
        this.updateState(sessionInfo.nodeUrl());
    }

    private void updateState(String url) {
        this.lastKnownUrl.set(url);
        this.idToVersionsRef = new LazyObjectRef<Map>(() -> {
            ListUnitCallInput input = ListUnitCallInput.builder().url(url).build();
            CallOutput<List<UnitStatus>> output = this.call.execute(input);
            if (!output.hasError() && !output.isEmpty()) {
                return output.body().stream().collect(Collectors.toMap(UnitStatus::getId, status -> status.getVersionToStatus().stream().map(UnitVersionStatus::getVersion).collect(Collectors.toSet())));
            }
            return null;
        });
    }

    @Override
    public void onDisconnect() {
        this.idToVersionsRef = null;
    }

    @Override
    public Set<String> versions(String unitId) {
        return this.idToVersionsRef == null || this.idToVersionsRef.get() == null ? Set.of() : this.idToVersionsRef.get().get(unitId);
    }

    @Override
    public Set<String> ids() {
        return this.idToVersionsRef == null || this.idToVersionsRef.get() == null ? Set.of() : this.idToVersionsRef.get().keySet();
    }

    @Override
    public void refresh() {
        this.onDisconnect();
        this.updateState(this.lastKnownUrl.get());
    }
}

