/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class OffheapReadWriteLock {
    private static final int DFLT_OFFHEAP_RWLOCK_SPIN_COUNT = 32;
    private static final String IGNITE_OFFHEAP_RWLOCK_SPIN_COUNT = "IGNITE_OFFHEAP_RWLOCK_SPIN_COUNT";
    private static final int SPIN_CNT = IgniteSystemProperties.getInteger("IGNITE_OFFHEAP_RWLOCK_SPIN_COUNT", 32);
    public static final int TAG_LOCK_ALWAYS = -1;
    public static final int LOCK_SIZE = 8;
    public static final int MAX_WAITERS = 65535;
    private final ReentrantLock[] locks;
    private final Condition[] readConditions;
    private final Condition[] writeConditions;
    private final int monitorsMask;

    public OffheapReadWriteLock(int concLvl) {
        if ((concLvl & concLvl - 1) != 0) {
            throw new IllegalArgumentException("Concurrency level must be a power of 2: " + concLvl);
        }
        this.monitorsMask = concLvl - 1;
        this.locks = new ReentrantLock[concLvl];
        this.readConditions = new Condition[concLvl];
        this.writeConditions = new Condition[concLvl];
        for (int i = 0; i < this.locks.length; ++i) {
            ReentrantLock lock;
            this.locks[i] = lock = new ReentrantLock();
            this.readConditions[i] = lock.newCondition();
            this.writeConditions[i] = lock.newCondition();
        }
    }

    public void init(long lock, int tag) {
        assert ((tag &= 0xFFFF) != 0);
        GridUnsafe.putLong(lock, (long)tag << 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readLock(long lock, int tag) {
        long state = GridUnsafe.getLongVolatile(null, lock);
        assert (state != 0L);
        int writeWaitCnt = this.writersWaitCount(state);
        if (writeWaitCnt == 0) {
            for (int i = 0; i < SPIN_CNT; ++i) {
                if (!this.checkTag(state, tag)) {
                    return false;
                }
                if (this.canReadLock(state)) {
                    if (GridUnsafe.compareAndSwapLong(null, lock, state, this.updateState(state, 1, 0, 0))) {
                        return true;
                    }
                    --i;
                }
                state = GridUnsafe.getLongVolatile(null, lock);
            }
        }
        int idx = this.lockIndex(lock);
        ReentrantLock lockObj = this.locks[idx];
        lockObj.lock();
        try {
            this.updateReadersWaitCount(lock, lockObj, 1);
            boolean bl = this.waitAcquireReadLock(lock, idx, tag);
            return bl;
        }
        finally {
            lockObj.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUnlock(long lock) {
        long updated;
        long state;
        do {
            if (this.lockCount(state = GridUnsafe.getLongVolatile(null, lock)) <= 0) {
                throw new IllegalMonitorStateException("Attempted to release a read lock while not holding it [lock=" + StringUtils.hexLong(lock) + ", state=" + StringUtils.hexLong(state) + "]");
            }
            updated = this.updateState(state, -1, 0, 0);
            assert (updated != 0L);
        } while (!GridUnsafe.compareAndSwapLong(null, lock, state, updated));
        if (this.lockCount(updated) == 0 && this.writersWaitCount(updated) > 0) {
            int idx = this.lockIndex(lock);
            ReentrantLock lockObj = this.locks[idx];
            lockObj.lock();
            try {
                this.writeConditions[idx].signalAll();
            }
            finally {
                lockObj.unlock();
            }
        }
    }

    public boolean tryWriteLock(long lock, int tag) {
        long state = GridUnsafe.getLongVolatile(null, lock);
        return this.checkTag(state, tag) && this.canWriteLock(state) && GridUnsafe.compareAndSwapLong(null, lock, state, this.updateState(state, -1, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeLock(long lock, int tag) {
        assert (tag != 0);
        for (int i = 0; i < SPIN_CNT; ++i) {
            long state = GridUnsafe.getLongVolatile(null, lock);
            assert (state != 0L);
            if (!this.checkTag(state, tag)) {
                return false;
            }
            if (!this.canWriteLock(state)) continue;
            if (GridUnsafe.compareAndSwapLong(null, lock, state, this.updateState(state, -1, 0, 0))) {
                return true;
            }
            --i;
        }
        int idx = this.lockIndex(lock);
        ReentrantLock lockObj = this.locks[idx];
        lockObj.lock();
        try {
            this.updateWritersWaitCount(lock, lockObj, 1);
            boolean bl = this.waitAcquireWriteLock(lock, idx, tag);
            return bl;
        }
        finally {
            lockObj.unlock();
        }
    }

    public boolean isWriteLocked(long lock) {
        return this.lockCount(GridUnsafe.getLongVolatile(null, lock)) == -1;
    }

    public boolean isReadLocked(long lock) {
        return this.lockCount(GridUnsafe.getLongVolatile(null, lock)) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUnlock(long lock, int tag) {
        long updated;
        long state;
        assert (tag != 0);
        do {
            if (this.lockCount(state = GridUnsafe.getLongVolatile(null, lock)) != -1) {
                throw new IllegalMonitorStateException("Attempted to release write lock while not holding it [lock=" + StringUtils.hexLong(lock) + ", state=" + StringUtils.hexLong(state) + "]");
            }
            updated = this.releaseWithTag(state, tag);
            assert (updated != 0L);
        } while (!GridUnsafe.compareAndSwapLong(null, lock, state, updated));
        int writeWaitCnt = this.writersWaitCount(updated);
        int readWaitCnt = this.readersWaitCount(updated);
        if (writeWaitCnt > 0 || readWaitCnt > 0) {
            int idx = this.lockIndex(lock);
            ReentrantLock lockObj = this.locks[idx];
            lockObj.lock();
            try {
                this.signalNextWaiter(writeWaitCnt, idx);
            }
            finally {
                lockObj.unlock();
            }
        }
    }

    private void signalNextWaiter(int writeWaitCnt, int idx) {
        if (writeWaitCnt == 0) {
            Condition readCondition = this.readConditions[idx];
            readCondition.signalAll();
        } else {
            Condition writeCond = this.writeConditions[idx];
            writeCond.signalAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Boolean upgradeToWriteLock(long lock, int tag) {
        for (int i = 0; i < SPIN_CNT; ++i) {
            long state = GridUnsafe.getLongVolatile(null, lock);
            if (!this.checkTag(state, tag)) {
                return null;
            }
            if (this.lockCount(state) != 1) continue;
            if (GridUnsafe.compareAndSwapLong(null, lock, state, this.updateState(state, -2, 0, 0))) {
                return true;
            }
            --i;
        }
        int idx = this.lockIndex(lock);
        ReentrantLock lockObj = this.locks[idx];
        lockObj.lock();
        try {
            while (true) {
                long state;
                if (!this.checkTag(state = GridUnsafe.getLongVolatile(null, lock), tag)) {
                    Boolean bl = null;
                    return bl;
                }
                if (this.lockCount(state) == 1) {
                    if (!GridUnsafe.compareAndSwapLong(null, lock, state, this.updateState(state, -2, 0, 0))) continue;
                    Boolean bl = true;
                    return bl;
                }
                if (GridUnsafe.compareAndSwapLong(null, lock, state, this.updateState(state, -1, 0, 1))) break;
            }
            Boolean bl = this.waitAcquireWriteLock(lock, idx, tag);
            return bl;
        }
        finally {
            lockObj.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean waitAcquireReadLock(long lock, int lockIdx, int tag) {
        lockObj = this.locks[lockIdx];
        waitCond = this.readConditions[lockIdx];
        if (!OffheapReadWriteLock.$assertionsDisabled && !lockObj.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        interrupted = false;
        while (true) {
            block12: {
                block11: {
                    state = GridUnsafe.getLongVolatile(null, lock);
                    if (this.checkTag(state, tag)) ** GOTO lbl21
                    updated = this.updateState(state, 0, -1, 0);
                    if (!GridUnsafe.compareAndSwapLong(null, lock, state, updated)) break block11;
                    writeWaitCnt = this.writersWaitCount(updated);
                    this.signalNextWaiter(writeWaitCnt, lockIdx);
                    var13_12 = false;
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return var13_12;
                }
                continue;
lbl21:
                // 1 sources

                if (!this.canReadLock(state)) ** GOTO lbl32
                updated = this.updateState(state, 1, -1, 0);
                if (!GridUnsafe.compareAndSwapLong(null, lock, state, updated)) break block12;
                var12_11 = true;
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return var12_11;
            }
            try {
                continue;
lbl32:
                // 1 sources

                waitCond.await();
            }
            catch (InterruptedException ignore) {
                interrupted = true;
            }
            continue;
            break;
        }
        catch (Throwable var14_13) {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            throw var14_13;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean waitAcquireWriteLock(long lock, int lockIdx, int tag) {
        lockObj = this.locks[lockIdx];
        waitCond = this.writeConditions[lockIdx];
        if (!OffheapReadWriteLock.$assertionsDisabled && !lockObj.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        interrupted = false;
        while (true) {
            block12: {
                block11: {
                    state = GridUnsafe.getLongVolatile(null, lock);
                    if (this.checkTag(state, tag)) ** GOTO lbl21
                    updated = this.updateState(state, 0, 0, -1);
                    if (!GridUnsafe.compareAndSwapLong(null, lock, state, updated)) break block11;
                    writeWaitCnt = this.writersWaitCount(updated);
                    this.signalNextWaiter(writeWaitCnt, lockIdx);
                    var13_12 = false;
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return var13_12;
                }
                continue;
lbl21:
                // 1 sources

                if (!this.canWriteLock(state)) ** GOTO lbl32
                updated = this.updateState(state, -1, 0, -1);
                if (!GridUnsafe.compareAndSwapLong(null, lock, state, updated)) break block12;
                var12_11 = true;
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return var12_11;
            }
            try {
                continue;
lbl32:
                // 1 sources

                waitCond.await();
            }
            catch (InterruptedException ignore) {
                interrupted = true;
            }
            continue;
            break;
        }
        catch (Throwable var14_13) {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            throw var14_13;
        }
    }

    private int lockIndex(long lock) {
        return IgniteUtils.safeAbs(IgniteUtils.hash(lock)) & this.monitorsMask;
    }

    private boolean canReadLock(long state) {
        return this.lockCount(state) >= 0;
    }

    private boolean canWriteLock(long state) {
        return this.lockCount(state) == 0;
    }

    private boolean checkTag(long state, int tag) {
        return tag < 0 || this.tag(state) == tag;
    }

    private int lockCount(long state) {
        return (short)(state & 0xFFFFL);
    }

    private int tag(long state) {
        return (int)(state >>> 16 & 0xFFFFL);
    }

    private int writersWaitCount(long state) {
        return (int)(state >>> 48 & 0xFFFFL);
    }

    private int readersWaitCount(long state) {
        return (int)(state >>> 32 & 0xFFFFL);
    }

    private long updateState(long state, int lockDelta, int readersWaitDelta, int writersWaitDelta) {
        int lock = this.lockCount(state);
        int tag = this.tag(state);
        int readersWait = this.readersWaitCount(state);
        int writersWait = this.writersWaitCount(state);
        lock += lockDelta;
        writersWait += writersWaitDelta;
        if ((readersWait += readersWaitDelta) > 65535) {
            throw new IllegalStateException("Failed to add read waiter (too many waiting threads): 65535");
        }
        if (writersWait > 65535) {
            throw new IllegalStateException("Failed to add write waiter (too many waiting threads): 65535");
        }
        assert (readersWait >= 0) : readersWait;
        assert (writersWait >= 0) : writersWait;
        assert (lock >= -1);
        return this.buildState(writersWait, readersWait, tag, lock);
    }

    private long releaseWithTag(long state, int newTag) {
        int lock = this.lockCount(state);
        int readersWait = this.readersWaitCount(state);
        int writersWait = this.writersWaitCount(state);
        int tag = newTag == -1 ? this.tag(state) : newTag & 0xFFFF;
        ++lock;
        assert (readersWait >= 0) : readersWait;
        assert (writersWait >= 0) : writersWait;
        assert (lock >= -1);
        return this.buildState(writersWait, readersWait, tag, lock);
    }

    private long buildState(int writersWait, int readersWait, int tag, int lock) {
        assert ((tag & 0xFFFF0000) == 0);
        return (long)writersWait << 48 | (long)readersWait << 32 | ((long)tag & 0xFFFFL) << 16 | (long)lock & 0xFFFFL;
    }

    private void updateReadersWaitCount(long lock, ReentrantLock lockObj, int delta) {
        long updated;
        long state;
        assert (lockObj.isHeldByCurrentThread());
        while (!GridUnsafe.compareAndSwapLong(null, lock, state = GridUnsafe.getLongVolatile(null, lock), updated = this.updateState(state, 0, delta, 0))) {
        }
    }

    private void updateWritersWaitCount(long lock, ReentrantLock lockObj, int delta) {
        long updated;
        long state;
        assert (lockObj.isHeldByCurrentThread());
        while (!GridUnsafe.compareAndSwapLong(null, lock, state = GridUnsafe.getLongVolatile(null, lock), updated = this.updateState(state, 0, 0, delta))) {
        }
    }
}

