/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.VacuumTxStateReplicaRequest;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class PersistentTxStateVacuumizer {
    private static final IgniteLogger LOG = Loggers.forClass(PersistentTxStateVacuumizer.class);
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final ReplicaService replicaService;
    private final ClusterNode localNode;
    private final ClockService clockService;
    private final PlacementDriver placementDriver;

    public PersistentTxStateVacuumizer(ReplicaService replicaService, ClusterNode localNode, ClockService clockService, PlacementDriver placementDriver) {
        this.replicaService = replicaService;
        this.localNode = localNode;
        this.clockService = clockService;
        this.placementDriver = placementDriver;
    }

    public CompletableFuture<PersistentTxStateVacuumResult> vacuumPersistentTxStates(Map<TablePartitionId, Set<VacuumizableTx>> txIds) {
        ConcurrentHashMap.KeySetView successful = ConcurrentHashMap.newKeySet();
        ArrayList futures = new ArrayList();
        AtomicInteger vacuumizedPersistentTxnStatesCount = new AtomicInteger();
        HybridTimestamp now = this.clockService.now();
        txIds.forEach((commitPartitionId, txs) -> {
            CompletionStage future = this.placementDriver.getPrimaryReplica((ReplicationGroupId)commitPartitionId, now).thenCompose(replicaMeta -> {
                if (replicaMeta != null && this.localNode.id().equals(replicaMeta.getLeaseholderId())) {
                    HashSet<UUID> filteredTxIds = new HashSet<UUID>();
                    for (VacuumizableTx v2 : txs) {
                        if (v2.cleanupCompletionTimestamp == null) {
                            successful.add(v2.txId);
                            continue;
                        }
                        filteredTxIds.add(v2.txId);
                    }
                    VacuumTxStateReplicaRequest request = TX_MESSAGES_FACTORY.vacuumTxStateReplicaRequest().enlistmentConsistencyToken(replicaMeta.getStartTime().longValue()).groupId((ReplicationGroupIdMessage)ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)commitPartitionId)).transactionIds(filteredTxIds).build();
                    return this.replicaService.invoke(this.localNode, (ReplicaRequest)request).whenComplete((v, e) -> {
                        if (e == null) {
                            successful.addAll(filteredTxIds);
                            vacuumizedPersistentTxnStatesCount.addAndGet(filteredTxIds.size());
                        } else if (ExceptionUtils.unwrapCause((Throwable)e) instanceof PrimaryReplicaMissException) {
                            LOG.debug("Failed to vacuum tx states from the persistent storage.", e);
                        } else {
                            LOG.warn("Failed to vacuum tx states from the persistent storage.", e);
                        }
                    });
                }
                successful.addAll(txs.stream().map(v -> v.txId).collect(Collectors.toSet()));
                return CompletableFutures.nullCompletedFuture();
            });
            futures.add(future);
        });
        return CompletableFutures.allOf(futures).handle((unused, unusedEx) -> new PersistentTxStateVacuumResult(successful, vacuumizedPersistentTxnStatesCount.get()));
    }

    public static class PersistentTxStateVacuumResult {
        final Set<UUID> txnsToVacuum;
        final int vacuumizedPersistentTxnStatesCount;

        public PersistentTxStateVacuumResult(Set<UUID> txnsToVacuum, int vacuumizedPersistentTxnStatesCount) {
            this.txnsToVacuum = txnsToVacuum;
            this.vacuumizedPersistentTxnStatesCount = vacuumizedPersistentTxnStatesCount;
        }
    }

    public static class VacuumizableTx {
        final UUID txId;
        @Nullable
        final Long cleanupCompletionTimestamp;

        VacuumizableTx(UUID txId, @Nullable Long cleanupCompletionTimestamp) {
            this.txId = txId;
            this.cleanupCompletionTimestamp = cleanupCompletionTimestamp;
        }
    }
}

