/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.metrics;

import io.micronaut.http.annotation.Controller;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.metrics.message.MetricSourceDto;
import org.apache.ignite.internal.metrics.messaging.MetricMessaging;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.metric.ClusterMetricApi;
import org.apache.ignite.internal.rest.api.metric.MetricSource;
import org.apache.ignite.internal.rest.api.metric.NodeMetricSources;
import org.apache.ignite.internal.rest.metrics.exception.MetricNotFoundException;
import org.apache.ignite.internal.util.ExceptionUtils;

@Controller(value="/management/v1/metric/cluster")
public class ClusterMetricController
implements ClusterMetricApi,
ResourceHolder {
    private MetricMessaging messaging;

    public ClusterMetricController(MetricMessaging messaging) {
        this.messaging = messaging;
    }

    public CompletableFuture<Void> enable(String srcName) {
        return this.messaging.broadcastMetricEnableAsync(srcName).exceptionally(ClusterMetricController::mapException);
    }

    public CompletableFuture<Void> disable(String srcName) {
        return this.messaging.broadcastMetricDisableAsync(srcName).exceptionally(ClusterMetricController::mapException);
    }

    public CompletableFuture<Collection<NodeMetricSources>> listMetricSources() {
        return ((CompletableFuture)this.messaging.broadcastMetricSourcesAsync().exceptionally(ClusterMetricController::mapException)).thenApply(ClusterMetricController::fromDto);
    }

    private static List<NodeMetricSources> fromDto(Map<String, Collection<MetricSourceDto>> sources) {
        return sources.entrySet().stream().map(ClusterMetricController::fromDto).collect(Collectors.toList());
    }

    private static NodeMetricSources fromDto(Map.Entry<String, Collection<MetricSourceDto>> entry) {
        List sources = entry.getValue().stream().map(ClusterMetricController::fromDto).collect(Collectors.toList());
        return new NodeMetricSources(entry.getKey(), sources);
    }

    private static MetricSource fromDto(MetricSourceDto source) {
        return new MetricSource(source.name(), source.enabled());
    }

    private static <T> T mapException(Throwable throwable) {
        Throwable cause = ExceptionUtils.unwrapCause((Throwable)throwable);
        if (cause instanceof IllegalStateException) {
            throw new MetricNotFoundException(cause);
        }
        throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)cause);
    }

    public void cleanResources() {
        this.messaging = null;
    }
}

