/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

public class IgniteCustomAssignmentsRules
implements SqlTypeMappingRule {
    private final Map<SqlTypeName, ImmutableSet<SqlTypeName>> map;
    private static final IgniteCustomAssignmentsRules INSTANCE;

    private IgniteCustomAssignmentsRules(Map<SqlTypeName, ImmutableSet<SqlTypeName>> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    public Map<SqlTypeName, ImmutableSet<SqlTypeName>> getTypeMapping() {
        return this.map;
    }

    public static IgniteCustomAssignmentsRules instance() {
        return INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        Builder rules = IgniteCustomAssignmentsRules.builder();
        EnumSet<SqlTypeName> rule = EnumSet.noneOf(SqlTypeName.class);
        rules.add(SqlTypeName.MULTISET, EnumSet.of(SqlTypeName.MULTISET));
        rule.clear();
        rule.addAll(SqlTypeName.EXACT_TYPES);
        rule.addAll(SqlTypeName.FRACTIONAL_TYPES);
        rule.addAll(SqlTypeName.CHAR_TYPES);
        for (Object type : SqlTypeName.FRACTIONAL_TYPES) {
            rules.add((SqlTypeName)type, rule);
        }
        rule.add(SqlTypeName.INTERVAL_YEAR);
        rule.add(SqlTypeName.INTERVAL_MONTH);
        rule.add(SqlTypeName.INTERVAL_DAY);
        rule.add(SqlTypeName.INTERVAL_HOUR);
        rule.add(SqlTypeName.INTERVAL_MINUTE);
        rule.add(SqlTypeName.INTERVAL_SECOND);
        for (Object type : SqlTypeName.EXACT_TYPES) {
            rules.add((SqlTypeName)type, rule);
        }
        rule.clear();
        rule.addAll(SqlTypeName.BINARY_TYPES);
        for (Object type : SqlTypeName.BINARY_TYPES) {
            rules.add((SqlTypeName)type, rule);
        }
        rule.clear();
        rule.addAll(SqlTypeName.CHAR_TYPES);
        rule.addAll(SqlTypeName.EXACT_TYPES);
        rule.addAll(SqlTypeName.APPROX_TYPES);
        rule.addAll(SqlTypeName.DAY_INTERVAL_TYPES);
        rule.addAll(SqlTypeName.YEAR_INTERVAL_TYPES);
        rule.add(SqlTypeName.BOOLEAN);
        rule.add(SqlTypeName.DATE);
        rule.add(SqlTypeName.TIME);
        rule.add(SqlTypeName.TIMESTAMP);
        rule.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        rules.add(SqlTypeName.CHAR, rule);
        rules.add(SqlTypeName.VARCHAR, rule);
        rules.add(SqlTypeName.BOOLEAN, EnumSet.of(SqlTypeName.BOOLEAN, SqlTypeName.CHAR, SqlTypeName.VARCHAR));
        rule.clear();
        rule.add(SqlTypeName.DATE);
        rule.addAll(SqlTypeName.CHAR_TYPES);
        rule.add(SqlTypeName.TIMESTAMP);
        rule.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        rules.add(SqlTypeName.DATE, rule);
        rule.clear();
        rule.add(SqlTypeName.TIME);
        rule.addAll(SqlTypeName.CHAR_TYPES);
        rule.add(SqlTypeName.TIMESTAMP);
        rule.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        rules.add(SqlTypeName.TIME, rule);
        rules.add(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, EnumSet.of(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE));
        rule.clear();
        rule.add(SqlTypeName.TIMESTAMP);
        rule.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        rule.addAll(SqlTypeName.CHAR_TYPES);
        rule.add(SqlTypeName.TIME);
        rule.add(SqlTypeName.DATE);
        rules.add(SqlTypeName.TIMESTAMP, rule);
        rule.clear();
        rule.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        rule.add(SqlTypeName.TIMESTAMP);
        rule.addAll(SqlTypeName.CHAR_TYPES);
        rule.add(SqlTypeName.TIME);
        rule.add(SqlTypeName.DATE);
        rules.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, rule);
        rule.clear();
        rule.add(SqlTypeName.GEOMETRY);
        rule.addAll(SqlTypeName.CHAR_TYPES);
        rules.add(SqlTypeName.GEOMETRY, rule);
        rule.clear();
        rule.addAll(SqlTypeName.CHAR_TYPES);
        rule.addAll(SqlTypeName.YEAR_INTERVAL_TYPES);
        rules.add(SqlTypeName.INTERVAL_YEAR_MONTH, rule);
        rule.clear();
        rule.addAll(SqlTypeName.CHAR_TYPES);
        rule.addAll(SqlTypeName.DAY_INTERVAL_TYPES);
        List<SqlTypeName> multiIntervals = List.of(SqlTypeName.INTERVAL_DAY_HOUR, SqlTypeName.INTERVAL_DAY_MINUTE, SqlTypeName.INTERVAL_DAY_SECOND, SqlTypeName.INTERVAL_HOUR_MINUTE, SqlTypeName.INTERVAL_HOUR_SECOND, SqlTypeName.INTERVAL_MINUTE_SECOND);
        for (SqlTypeName sqlTypeName : multiIntervals) {
            rules.add(sqlTypeName, rule);
        }
        rule.clear();
        rule.addAll(SqlTypeName.CHAR_TYPES);
        rule.addAll(SqlTypeName.EXACT_TYPES);
        rule.addAll(SqlTypeName.YEAR_INTERVAL_TYPES);
        List<SqlTypeName> singleYearIntervals = List.of(SqlTypeName.INTERVAL_YEAR, SqlTypeName.INTERVAL_MONTH);
        for (SqlTypeName type : singleYearIntervals) {
            rules.add(type, rule);
        }
        rule.removeAll(SqlTypeName.YEAR_INTERVAL_TYPES);
        rule.addAll(SqlTypeName.DAY_INTERVAL_TYPES);
        List<SqlTypeName> list = List.of(SqlTypeName.INTERVAL_DAY, SqlTypeName.INTERVAL_HOUR, SqlTypeName.INTERVAL_MINUTE, SqlTypeName.INTERVAL_SECOND);
        for (SqlTypeName type : list) {
            rules.add(type, rule);
        }
        rules.add(SqlTypeName.ARRAY, EnumSet.of(SqlTypeName.ARRAY));
        rules.add(SqlTypeName.MAP, EnumSet.of(SqlTypeName.MAP));
        rules.add(SqlTypeName.SYMBOL, EnumSet.of(SqlTypeName.SYMBOL));
        rule.clear();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rule.add(SqlTypeName.BIGINT);
        rule.add(SqlTypeName.DECIMAL);
        rule.add(SqlTypeName.FLOAT);
        rule.add(SqlTypeName.REAL);
        rule.add(SqlTypeName.TIME);
        rule.add(SqlTypeName.DATE);
        rule.add(SqlTypeName.TIMESTAMP);
        rule.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        rules.add(SqlTypeName.ANY, rule);
        INSTANCE = new IgniteCustomAssignmentsRules(rules.map);
    }

    public static class Builder {
        final Map<SqlTypeName, ImmutableSet<SqlTypeName>> map = new HashMap<SqlTypeName, ImmutableSet<SqlTypeName>>();
        final LoadingCache<Set<SqlTypeName>, ImmutableSet<SqlTypeName>> sets = CacheBuilder.newBuilder().build(CacheLoader.from(set -> Sets.immutableEnumSet((Iterable)set)));

        Builder() {
        }

        void add(SqlTypeName fromType, Set<SqlTypeName> toTypes) {
            try {
                this.map.put(fromType, (ImmutableSet<SqlTypeName>)((ImmutableSet)this.sets.get(toTypes)));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                throw Util.throwAsRuntime((String)"populating SqlTypeAssignmentRules", (Throwable)Util.causeOrSelf((Throwable)e));
            }
        }
    }
}

