/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.dsl.MetaStorageMessagesFactory;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.OperationType;
import org.apache.ignite.internal.metastorage.dsl.StatementResult;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.util.ArrayUtils;

public final class Operations {
    private static final MetaStorageMessagesFactory MSG_FACTORY = new MetaStorageMessagesFactory();
    private static final Operation NO_OP = MSG_FACTORY.operation().type(OperationType.NO_OP).build();
    private final List<Operation> operations;

    private Operations(Operation ... operations) {
        this.operations = List.of(operations);
    }

    public Update yield(boolean result) {
        StatementResult statementResult = MSG_FACTORY.statementResult().result(ByteBuffer.allocate(1).put((byte)(result ? 1 : 0)).flip()).build();
        return MSG_FACTORY.update().operations(this.operations).result(statementResult).build();
    }

    public Update yield(int result) {
        StatementResult statementResult = MSG_FACTORY.statementResult().result(ByteBuffer.allocate(4).putInt(result).flip()).build();
        return MSG_FACTORY.update().operations(this.operations).result(statementResult).build();
    }

    public Update yield() {
        StatementResult statementResult = MSG_FACTORY.statementResult().result(ArrayUtils.EMPTY_BYTE_BUFFER).build();
        return MSG_FACTORY.update().operations(this.operations).result(statementResult).build();
    }

    public static Operations ops(Operation ... operations) {
        return new Operations(operations);
    }

    public static Operation remove(ByteArray key) {
        return MSG_FACTORY.operation().key(ByteBuffer.wrap(key.bytes())).type(OperationType.REMOVE).build();
    }

    public static Operation put(ByteArray key, byte[] value) {
        return Operations.put(ByteBuffer.wrap(key.bytes()), ByteBuffer.wrap(value));
    }

    public static Operation put(ByteArray key, ByteBuffer value) {
        return Operations.put(ByteBuffer.wrap(key.bytes()), value);
    }

    public static Operation put(ByteBuffer key, ByteBuffer value) {
        return MSG_FACTORY.operation().key(key).value(value).type(OperationType.PUT).build();
    }

    public static Operation noop() {
        return NO_OP;
    }
}

