/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.s3.encrypt;

import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.discovery.tcp.ipfinder.s3.encrypt.EncryptionService;

public class SymmetricKeyEncryptionService
implements EncryptionService {
    private Key secretKey;
    private Cipher encCipher;
    private Cipher decCipher;

    public SymmetricKeyEncryptionService setSecretKey(Key secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Override
    public void init() throws IgniteException {
        if (this.secretKey == null) {
            throw new IgniteException("Secret key was not set / was set to null.");
        }
        this.encCipher = IgniteUtils.createCipher((Key)this.secretKey, (int)1);
        this.decCipher = IgniteUtils.createCipher((Key)this.secretKey, (int)2);
    }

    @Override
    public byte[] encrypt(byte[] data) {
        if (data == null) {
            throw new IgniteException("Parameter [data] cannot be null");
        }
        if (this.encCipher == null) {
            throw new IgniteException("The init() method was not called.");
        }
        try {
            return this.encCipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) {
        if (data == null) {
            throw new IgniteException("Parameter [data] cannot be null");
        }
        if (this.decCipher == null) {
            throw new IgniteException("The init() method was not called.");
        }
        try {
            return this.decCipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public String toString() {
        return S.toString(SymmetricKeyEncryptionService.class, (Object)this, (String)"super", (Object)super.toString());
    }
}

