/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.exception.ParseException;
import com.amazonaws.encryptionsdk.internal.EncryptionContextSerializer;
import com.amazonaws.encryptionsdk.internal.PrimitivesParser;
import com.amazonaws.encryptionsdk.model.CiphertextType;
import com.amazonaws.encryptionsdk.model.ContentType;
import com.amazonaws.encryptionsdk.model.KeyBlob;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CiphertextHeaders {
    private static final SecureRandom RND = new SecureRandom();
    private byte version_ = (byte)-1;
    private byte typeVal_;
    private short cryptoAlgoVal_ = (short)-1;
    private byte[] messageId_;
    private int encryptionContextLen_ = -1;
    private byte[] encryptionContext_ = new byte[0];
    private int cipherKeyCount_ = -1;
    private List<KeyBlob> cipherKeyBlobs_;
    private byte contentTypeVal_ = (byte)-1;
    private int reservedField_ = -1;
    private short nonceLen_ = (short)-1;
    private int frameLength_ = -1;
    private byte[] headerNonce_;
    private byte[] headerTag_;
    private int currKeyBlobIndex_ = 0;
    private boolean isComplete_;

    public CiphertextHeaders() {
    }

    public CiphertextHeaders(byte version, CiphertextType type, CryptoAlgorithm cryptoAlgo, byte[] encryptionContext, List<KeyBlob> keyBlobs, ContentType contentType, int frameSize) {
        this.version_ = version;
        this.typeVal_ = type.getValue();
        this.cryptoAlgoVal_ = cryptoAlgo.getValue();
        this.encryptionContext_ = (byte[])encryptionContext.clone();
        if (this.encryptionContext_.length > 65535) {
            throw new AwsCryptoException("Size of encryption context exceeds the allowed maximum 65535");
        }
        this.encryptionContextLen_ = encryptionContext.length;
        this.cipherKeyCount_ = keyBlobs.size();
        this.cipherKeyBlobs_ = new ArrayList<KeyBlob>(keyBlobs);
        this.contentTypeVal_ = contentType.getValue();
        this.reservedField_ = 0;
        this.nonceLen_ = cryptoAlgo.getNonceLen();
        this.messageId_ = new byte[16];
        RND.nextBytes(this.messageId_);
        this.frameLength_ = frameSize;
        this.isComplete_ = true;
    }

    public Boolean isComplete() {
        return this.isComplete_;
    }

    private int parseVersion(byte[] b, int off) throws ParseException {
        this.version_ = PrimitivesParser.parseByte(b, off);
        return 1;
    }

    private int parseType(byte[] b, int off) throws ParseException {
        this.typeVal_ = PrimitivesParser.parseByte(b, off);
        if (CiphertextType.deserialize(this.typeVal_) == null) {
            throw new BadCiphertextException("Invalid ciphertext type.");
        }
        return 1;
    }

    private int parseAlgoId(byte[] b, int off) throws ParseException {
        this.cryptoAlgoVal_ = PrimitivesParser.parseShort(b, off);
        if (CryptoAlgorithm.deserialize(this.cryptoAlgoVal_) == null) {
            throw new BadCiphertextException("Invalid algorithm identifier in ciphertext");
        }
        return 2;
    }

    private int parseMessageId(byte[] b, int off) throws ParseException {
        int messageIdLen = 16;
        int len = b.length - off;
        if (len >= 16) {
            this.messageId_ = Arrays.copyOfRange(b, off, off + 16);
            return 16;
        }
        throw new ParseException("Not enough bytes to parse serial number");
    }

    private int parseEncryptionContextLen(byte[] b, int off) throws ParseException {
        this.encryptionContextLen_ = PrimitivesParser.parseUnsignedShort(b, off);
        if (this.encryptionContextLen_ < 0) {
            throw new BadCiphertextException("Invalid encryption context length in ciphertext");
        }
        return 2;
    }

    private int parseEncryptionContext(byte[] b, int off) throws ParseException {
        int len = b.length - off;
        if (len >= this.encryptionContextLen_) {
            this.encryptionContext_ = Arrays.copyOfRange(b, off, off + this.encryptionContextLen_);
            return this.encryptionContextLen_;
        }
        throw new ParseException("Not enough bytes to parse encryption context");
    }

    private int parseEncryptedDataKeyCount(byte[] b, int off) throws ParseException {
        this.cipherKeyCount_ = PrimitivesParser.parseUnsignedShort(b, off);
        if (this.cipherKeyCount_ < 0) {
            throw new BadCiphertextException("Invalid cipher key count in ciphertext");
        }
        return 2;
    }

    private int parseEncryptedKeyBlob(byte[] b, int off) throws ParseException {
        return this.cipherKeyBlobs_.get(this.currKeyBlobIndex_).deserialize(b, off);
    }

    private int parseContentType(byte[] b, int off) throws ParseException {
        this.contentTypeVal_ = PrimitivesParser.parseByte(b, off);
        if (ContentType.deserialize(this.contentTypeVal_) == null) {
            throw new BadCiphertextException("Invalid content type in ciphertext.");
        }
        return 1;
    }

    private int parseReservedField(byte[] b, int off) throws ParseException {
        this.reservedField_ = PrimitivesParser.parseInt(b, off);
        if (this.reservedField_ != 0) {
            throw new BadCiphertextException("Invalid value for reserved field in ciphertext");
        }
        return 4;
    }

    private int parseNonceLen(byte[] b, int off) throws ParseException {
        this.nonceLen_ = PrimitivesParser.parseByte(b, off);
        if (this.nonceLen_ < 0) {
            throw new BadCiphertextException("Invalid nonce length in ciphertext");
        }
        return 1;
    }

    private int parseFramePayloadLength(byte[] b, int off) throws ParseException {
        this.frameLength_ = PrimitivesParser.parseInt(b, off);
        if (this.frameLength_ < 0) {
            throw new BadCiphertextException("Invalid frame length in ciphertext");
        }
        return 4;
    }

    private int parseHeaderNonce(byte[] b, int off) throws ParseException {
        int len = b.length - off;
        if (len >= this.nonceLen_) {
            this.headerNonce_ = Arrays.copyOfRange(b, off, off + this.nonceLen_);
            return this.nonceLen_;
        }
        throw new ParseException("Not enough bytes to parse header nonce");
    }

    private int parseHeaderTag(byte[] b, int off) throws ParseException {
        int len = b.length - off;
        CryptoAlgorithm cryptoAlgo = CryptoAlgorithm.deserialize(this.cryptoAlgoVal_);
        int tagLen = cryptoAlgo.getTagLen();
        if (len >= tagLen) {
            this.headerTag_ = Arrays.copyOfRange(b, off, off + tagLen);
            return tagLen;
        }
        throw new ParseException("Not enough bytes to parse header tag");
    }

    public int deserialize(byte[] b, int off) throws ParseException {
        if (b == null) {
            return 0;
        }
        int parsedBytes = 0;
        try {
            if (this.version_ < 0) {
                parsedBytes += this.parseVersion(b, off + parsedBytes);
            }
            if (this.typeVal_ == 0) {
                parsedBytes += this.parseType(b, off + parsedBytes);
            }
            if (this.cryptoAlgoVal_ < 0) {
                parsedBytes += this.parseAlgoId(b, off + parsedBytes);
            }
            if (this.messageId_ == null) {
                parsedBytes += this.parseMessageId(b, off + parsedBytes);
            }
            if (this.encryptionContextLen_ < 0) {
                parsedBytes += this.parseEncryptionContextLen(b, off + parsedBytes);
            }
            if (this.encryptionContextLen_ > 0 && this.encryptionContext_.length == 0) {
                parsedBytes += this.parseEncryptionContext(b, off + parsedBytes);
            }
            if (this.cipherKeyCount_ < 0) {
                parsedBytes += this.parseEncryptedDataKeyCount(b, off + parsedBytes);
                this.cipherKeyBlobs_ = Arrays.asList(new KeyBlob[this.cipherKeyCount_]);
            }
            if (this.cipherKeyCount_ > 0) {
                while (this.currKeyBlobIndex_ < this.cipherKeyCount_) {
                    if (this.cipherKeyBlobs_.get(this.currKeyBlobIndex_) == null) {
                        this.cipherKeyBlobs_.set(this.currKeyBlobIndex_, new KeyBlob());
                    }
                    if (!this.cipherKeyBlobs_.get(this.currKeyBlobIndex_).isComplete()) {
                        parsedBytes += this.parseEncryptedKeyBlob(b, off + parsedBytes);
                        if (!this.cipherKeyBlobs_.get(this.currKeyBlobIndex_).isComplete()) {
                            throw new ParseException("Not enough bytes to parse key blob");
                        }
                    }
                    ++this.currKeyBlobIndex_;
                }
            }
            if (this.contentTypeVal_ < 0) {
                parsedBytes += this.parseContentType(b, off + parsedBytes);
            }
            if (this.reservedField_ < 0) {
                parsedBytes += this.parseReservedField(b, off + parsedBytes);
            }
            if (this.nonceLen_ < 0) {
                parsedBytes += this.parseNonceLen(b, off + parsedBytes);
            }
            if (this.frameLength_ < 0) {
                parsedBytes += this.parseFramePayloadLength(b, off + parsedBytes);
            }
            if (this.nonceLen_ > 0 && this.headerNonce_ == null) {
                parsedBytes += this.parseHeaderNonce(b, off + parsedBytes);
            }
            if (this.headerTag_ == null) {
                parsedBytes += this.parseHeaderTag(b, off + parsedBytes);
            }
            this.isComplete_ = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return parsedBytes;
    }

    public byte[] serializeAuthenticatedFields() {
        try {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(outBytes);
            dataStream.writeByte(this.version_);
            dataStream.writeByte(this.typeVal_);
            dataStream.writeShort(this.cryptoAlgoVal_);
            dataStream.write(this.messageId_);
            PrimitivesParser.writeUnsignedShort(dataStream, this.encryptionContextLen_);
            if (this.encryptionContextLen_ > 0) {
                dataStream.write(this.encryptionContext_);
            }
            dataStream.writeShort(this.cipherKeyCount_);
            for (int i = 0; i < this.cipherKeyCount_; ++i) {
                byte[] cipherKeyBlobBytes = this.cipherKeyBlobs_.get(i).toByteArray();
                dataStream.write(cipherKeyBlobBytes);
            }
            dataStream.writeByte(this.contentTypeVal_);
            dataStream.writeInt(this.reservedField_);
            dataStream.writeByte(this.nonceLen_);
            dataStream.writeInt(this.frameLength_);
            dataStream.close();
            return outBytes.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize cipher text headers", e);
        }
    }

    public byte[] toByteArray() {
        if (this.headerNonce_ == null || this.headerTag_ == null) {
            throw new AwsCryptoException("Header nonce and tag cannot be null.");
        }
        byte[] serializedFields = this.serializeAuthenticatedFields();
        int outLen = serializedFields.length + this.headerNonce_.length + this.headerTag_.length;
        ByteBuffer serializedBytes = ByteBuffer.allocate(outLen);
        serializedBytes.put(serializedFields);
        serializedBytes.put(this.headerNonce_);
        serializedBytes.put(this.headerTag_);
        return serializedBytes.array();
    }

    public byte getVersion() {
        return this.version_;
    }

    public CiphertextType getType() {
        return CiphertextType.deserialize(this.typeVal_);
    }

    public CryptoAlgorithm getCryptoAlgoId() {
        return CryptoAlgorithm.deserialize(this.cryptoAlgoVal_);
    }

    public int getEncryptionContextLen() {
        return this.encryptionContextLen_;
    }

    public byte[] getEncryptionContext() {
        return (byte[])this.encryptionContext_.clone();
    }

    public Map<String, String> getEncryptionContextMap() {
        return EncryptionContextSerializer.deserialize(this.encryptionContext_);
    }

    public int getEncryptedKeyBlobCount() {
        return this.cipherKeyCount_;
    }

    public List<KeyBlob> getEncryptedKeyBlobs() {
        return new ArrayList<KeyBlob>(this.cipherKeyBlobs_);
    }

    public ContentType getContentType() {
        return ContentType.deserialize(this.contentTypeVal_);
    }

    public byte[] getMessageId() {
        return this.messageId_ != null ? (byte[])this.messageId_.clone() : null;
    }

    public short getNonceLength() {
        return this.nonceLen_;
    }

    public int getFrameLength() {
        return this.frameLength_;
    }

    public byte[] getHeaderNonce() {
        return this.headerNonce_ != null ? (byte[])this.headerNonce_.clone() : null;
    }

    public byte[] getHeaderTag() {
        return this.headerTag_ != null ? (byte[])this.headerTag_.clone() : null;
    }

    public void setHeaderNonce(byte[] headerNonce) {
        this.headerNonce_ = (byte[])headerNonce.clone();
    }

    public void setHeaderTag(byte[] headerTag) {
        this.headerTag_ = (byte[])headerTag.clone();
    }
}

