/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.PageBlobsClearPagesResponse;
import com.azure.storage.blob.implementation.models.PageBlobsCopyIncrementalResponse;
import com.azure.storage.blob.implementation.models.PageBlobsCreateResponse;
import com.azure.storage.blob.implementation.models.PageBlobsGetPageRangesDiffResponse;
import com.azure.storage.blob.implementation.models.PageBlobsGetPageRangesResponse;
import com.azure.storage.blob.implementation.models.PageBlobsResizeResponse;
import com.azure.storage.blob.implementation.models.PageBlobsUpdateSequenceNumberResponse;
import com.azure.storage.blob.implementation.models.PageBlobsUploadPagesFromURLResponse;
import com.azure.storage.blob.implementation.models.PageBlobsUploadPagesResponse;
import com.azure.storage.blob.implementation.models.PremiumPageBlobAccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import com.azure.storage.blob.models.SequenceNumberActionType;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PageBlobsImpl {
    private final PageBlobsService service;
    private final AzureBlobStorageImpl client;

    PageBlobsImpl(AzureBlobStorageImpl client) {
        this.service = (PageBlobsService)RestProxy.create(PageBlobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobsCreateResponse> createWithResponseAsync(String containerName, String blob, long contentLength, long blobContentLength, Integer timeout, PremiumPageBlobAccessTier tier, Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId, String blobTagsString, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String blobType = "PageBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScope != null) {
            encryptionScopeInternal = encryptionScope.getEncryptionScope();
        }
        String encryptionScopeLocal = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.create(this.client.getUrl(), "PageBlob", containerName, blob, timeout, contentLength, tier, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScopeLocal, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blobContentLength, blobSequenceNumber, this.client.getVersion(), requestId, blobTagsString, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobsUploadPagesResponse> uploadPagesWithResponseAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "page";
        String pageWrite = "update";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScope != null) {
            encryptionScopeInternal = encryptionScope.getEncryptionScope();
        }
        String encryptionScopeLocal = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString((byte[])transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.uploadPages(this.client.getUrl(), "page", "update", containerName, blob, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, range, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScopeLocal, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobsClearPagesResponse> clearPagesWithResponseAsync(String containerName, String blob, long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "page";
        String pageWrite = "clear";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScope != null) {
            encryptionScopeInternal = encryptionScope.getEncryptionScope();
        }
        String encryptionScopeLocal = encryptionScopeInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.clearPages(this.client.getUrl(), "page", "clear", containerName, blob, contentLength, timeout, range, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScopeLocal, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobsUploadPagesFromURLResponse> uploadPagesFromURLWithResponseAsync(String containerName, String blob, URL sourceUrl, String sourceRange, long contentLength, String range, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "page";
        String pageWrite = "update";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScope != null) {
            encryptionScopeInternal = encryptionScope.getEncryptionScope();
        }
        String encryptionScopeLocal = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString((byte[])sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString((byte[])sourceContentcrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.uploadPagesFromURL(this.client.getUrl(), "page", "update", containerName, blob, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, contentLength, timeout, range, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScopeLocal, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobsGetPageRangesResponse> getPageRangesWithResponseAsync(String containerName, String blob, String snapshot, Integer timeout, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "pagelist";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getPageRanges(this.client.getUrl(), "pagelist", containerName, blob, snapshot, timeout, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobsGetPageRangesDiffResponse> getPageRangesDiffWithResponseAsync(String containerName, String blob, String snapshot, Integer timeout, String prevsnapshot, URL prevSnapshotUrl, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "pagelist";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getPageRangesDiff(this.client.getUrl(), "pagelist", containerName, blob, snapshot, timeout, prevsnapshot, prevSnapshotUrl, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobsResizeResponse> resizeWithResponseAsync(String containerName, String blob, long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "properties";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScope != null) {
            encryptionScopeInternal = encryptionScope.getEncryptionScope();
        }
        String encryptionScopeLocal = encryptionScopeInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.resize(this.client.getUrl(), "properties", containerName, blob, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScopeLocal, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blobContentLength, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumberWithResponseAsync(String containerName, String blob, SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId, Context context) {
        String comp = "properties";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.updateSequenceNumber(this.client.getUrl(), "properties", containerName, blob, timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sequenceNumberAction, blobSequenceNumber, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobsCopyIncrementalResponse> copyIncrementalWithResponseAsync(String containerName, String blob, URL copySource, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "incrementalcopy";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.copyIncremental(this.client.getUrl(), "incrementalcopy", containerName, blob, timeout, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource, this.client.getVersion(), requestId, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStoragePage")
    public static interface PageBlobsService {
        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsCreateResponse> create(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-blob-type") String var2, @PathParam(value="containerName") String var3, @PathParam(value="blob") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="x-ms-access-tier") PremiumPageBlobAccessTier var8, @HeaderParam(value="x-ms-blob-content-type") String var9, @HeaderParam(value="x-ms-blob-content-encoding") String var10, @HeaderParam(value="x-ms-blob-content-language") String var11, @HeaderParam(value="x-ms-blob-content-md5") String var12, @HeaderParam(value="x-ms-blob-cache-control") String var13, @HeaderParam(value="x-ms-meta-") Map<String, String> var14, @HeaderParam(value="x-ms-lease-id") String var15, @HeaderParam(value="x-ms-blob-content-disposition") String var16, @HeaderParam(value="x-ms-encryption-key") String var17, @HeaderParam(value="x-ms-encryption-key-sha256") String var18, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var19, @HeaderParam(value="x-ms-encryption-scope") String var20, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var21, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Match") String var23, @HeaderParam(value="If-None-Match") String var24, @HeaderParam(value="x-ms-if-tags") String var25, @HeaderParam(value="x-ms-blob-content-length") long var26, @HeaderParam(value="x-ms-blob-sequence-number") Long var28, @HeaderParam(value="x-ms-version") String var29, @HeaderParam(value="x-ms-client-request-id") String var30, @HeaderParam(value="x-ms-tags") String var31, @HeaderParam(value="Accept") String var32, Context var33);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsUploadPagesResponse> uploadPages(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="x-ms-page-write") String var3, @PathParam(value="containerName") String var4, @PathParam(value="blob") String var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-range") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-encryption-key") String var13, @HeaderParam(value="x-ms-encryption-key-sha256") String var14, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var15, @HeaderParam(value="x-ms-encryption-scope") String var16, @HeaderParam(value="x-ms-if-sequence-number-le") Long var17, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var18, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var19, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var20, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var21, @HeaderParam(value="If-Match") String var22, @HeaderParam(value="If-None-Match") String var23, @HeaderParam(value="x-ms-if-tags") String var24, @HeaderParam(value="x-ms-version") String var25, @HeaderParam(value="x-ms-client-request-id") String var26, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var27, @HeaderParam(value="Accept") String var28, Context var29);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsClearPagesResponse> clearPages(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="x-ms-page-write") String var3, @PathParam(value="containerName") String var4, @PathParam(value="blob") String var5, @HeaderParam(value="Content-Length") long var6, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-range") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-encryption-key") String var11, @HeaderParam(value="x-ms-encryption-key-sha256") String var12, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var13, @HeaderParam(value="x-ms-encryption-scope") String var14, @HeaderParam(value="x-ms-if-sequence-number-le") Long var15, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var16, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var17, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var18, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var19, @HeaderParam(value="If-Match") String var20, @HeaderParam(value="If-None-Match") String var21, @HeaderParam(value="x-ms-if-tags") String var22, @HeaderParam(value="x-ms-version") String var23, @HeaderParam(value="x-ms-client-request-id") String var24, @HeaderParam(value="Accept") String var25, Context var26);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsUploadPagesFromURLResponse> uploadPagesFromURL(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="x-ms-page-write") String var3, @PathParam(value="containerName") String var4, @PathParam(value="blob") String var5, @HeaderParam(value="x-ms-copy-source") URL var6, @HeaderParam(value="x-ms-source-range") String var7, @HeaderParam(value="x-ms-source-content-md5") String var8, @HeaderParam(value="x-ms-source-content-crc64") String var9, @HeaderParam(value="Content-Length") long var10, @QueryParam(value="timeout") Integer var12, @HeaderParam(value="x-ms-range") String var13, @HeaderParam(value="x-ms-encryption-key") String var14, @HeaderParam(value="x-ms-encryption-key-sha256") String var15, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var16, @HeaderParam(value="x-ms-encryption-scope") String var17, @HeaderParam(value="x-ms-lease-id") String var18, @HeaderParam(value="x-ms-if-sequence-number-le") Long var19, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var20, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Match") String var24, @HeaderParam(value="If-None-Match") String var25, @HeaderParam(value="x-ms-if-tags") String var26, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var27, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var28, @HeaderParam(value="x-ms-source-if-match") String var29, @HeaderParam(value="x-ms-source-if-none-match") String var30, @HeaderParam(value="x-ms-version") String var31, @HeaderParam(value="x-ms-client-request-id") String var32, @HeaderParam(value="Accept") String var33, Context var34);

        @Get(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsGetPageRangesResponse> getPageRanges(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @PathParam(value="containerName") String var3, @PathParam(value="blob") String var4, @QueryParam(value="snapshot") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="x-ms-if-tags") String var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="x-ms-client-request-id") String var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Get(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsGetPageRangesDiffResponse> getPageRangesDiff(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @PathParam(value="containerName") String var3, @PathParam(value="blob") String var4, @QueryParam(value="snapshot") String var5, @QueryParam(value="timeout") Integer var6, @QueryParam(value="prevsnapshot") String var7, @HeaderParam(value="x-ms-previous-snapshot-url") URL var8, @HeaderParam(value="x-ms-range") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, @HeaderParam(value="x-ms-if-tags") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="x-ms-client-request-id") String var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsResizeResponse> resize(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @PathParam(value="containerName") String var3, @PathParam(value="blob") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-encryption-key") String var7, @HeaderParam(value="x-ms-encryption-key-sha256") String var8, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var9, @HeaderParam(value="x-ms-encryption-scope") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, @HeaderParam(value="x-ms-if-tags") String var15, @HeaderParam(value="x-ms-blob-content-length") long var16, @HeaderParam(value="x-ms-version") String var18, @HeaderParam(value="x-ms-client-request-id") String var19, @HeaderParam(value="Accept") String var20, Context var21);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumber(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @PathParam(value="containerName") String var3, @PathParam(value="blob") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Match") String var9, @HeaderParam(value="If-None-Match") String var10, @HeaderParam(value="x-ms-if-tags") String var11, @HeaderParam(value="x-ms-sequence-number-action") SequenceNumberActionType var12, @HeaderParam(value="x-ms-blob-sequence-number") Long var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="x-ms-client-request-id") String var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsCopyIncrementalResponse> copyIncremental(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @PathParam(value="containerName") String var3, @PathParam(value="blob") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="x-ms-if-tags") String var10, @HeaderParam(value="x-ms-copy-source") URL var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @HeaderParam(value="Accept") String var14, Context var15);
    }
}

