/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.BitwiseGet$;
import org.apache.spark.sql.catalyst.expressions.BitwiseGetUtil$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, pos) - Returns the value of the bit (0 or 1) at the specified position.\n      The positions are numbered from right to left, starting at zero.\n      The position argument cannot be negative.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(11, 0);\n       1\n      > SELECT _FUNC_(11, 2);\n       0\n  ", since="3.2.0", group="bitwise_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005A\t\u0003\u0005K\u0001\tE\t\u0015!\u0003F\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011!A\u0007\u0001#b\u0001\n\u0003I\u0007\"B7\u0001\t\u0003r\u0007\"\u0002<\u0001\t\u0003:\bbBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003?\u0001A\u0011KA\u0011\u0011%\tY\u0003AA\u0001\n\u0003\ti\u0003C\u0005\u00024\u0001\t\n\u0011\"\u0001\u00026!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003\u001b\u0002\u0011\u0011!C!\u0003\u001fB\u0001\"a\u0018\u0001\u0003\u0003%\t!\u001b\u0005\n\u0003C\u0002\u0011\u0011!C\u0001\u0003GB\u0011\"!\u001b\u0001\u0003\u0003%\t%a\u001b\t\u0013\u0005e\u0004!!A\u0005\u0002\u0005m\u0004\"CAC\u0001\u0005\u0005I\u0011IAD\u000f%\tYKHA\u0001\u0012\u0003\tiK\u0002\u0005\u001e=\u0005\u0005\t\u0012AAX\u0011\u0019Yu\u0003\"\u0001\u0002>\"I\u0011qX\f\u0002\u0002\u0013\u0015\u0013\u0011\u0019\u0005\n\u0003\u0007<\u0012\u0011!CA\u0003\u000bD\u0011\"a3\u0018\u0003\u0003%\t)!4\t\u0013\u0005}w#!A\u0005\n\u0005\u0005(A\u0003\"ji^L7/Z$fi*\u0011q\u0004I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\"E\u0005A1-\u0019;bYf\u001cHO\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001YA\u001a$\b\u0011\t\u0003[9j\u0011AH\u0005\u0003_y\u0011\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00055\n\u0014B\u0001\u001a\u001f\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001b8\u001d\tiS'\u0003\u00027=\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001d:\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!A\u000e\u0010\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000fA\u0013x\u000eZ;diB\u00111(Q\u0005\u0003\u0005r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\tQ\t\u0005\u0002.\r&\u0011qI\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u001b:{\u0005CA\u0017\u0001\u0011\u0015\u0019U\u00011\u0001F\u0011\u0015IU\u00011\u0001F\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002%B\u00191KW/\u000f\u0005QKfBA+Y\u001b\u00051&BA,+\u0003\u0019a$o\\8u}%\tQ(\u0003\u00027y%\u00111\f\u0018\u0002\u0004'\u0016\f(B\u0001\u001c=!\tq\u0016-D\u0001`\u0015\t\u0001'%A\u0003usB,7/\u0003\u0002c?\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\tQ\r\u0005\u0002_M&\u0011qm\u0018\u0002\t\t\u0006$\u0018\rV=qK\u00069!-\u001b;TSj,W#\u00016\u0011\u0005mZ\u0017B\u00017=\u0005\rIe\u000e^\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004_J$\bCA\u001eq\u0013\t\tHHA\u0002B]fDQa]\u0005A\u0002=\fa\u0001^1sO\u0016$\b\"B;\n\u0001\u0004y\u0017a\u00019pg\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0005qz\f9\u0001\u0005\u0002zy6\t!P\u0003\u0002|=\u000591m\u001c3fO\u0016t\u0017BA?{\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007BB@\u000b\u0001\u0004\t\t!A\u0002dib\u00042!_A\u0002\u0013\r\t)A\u001f\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0019\tIA\u0003a\u0001q\u0006\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA\b!\u0011\t\t\"!\u0007\u000f\t\u0005M\u0011Q\u0003\t\u0003+rJ1!a\u0006=\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0003\u001f\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B'\u0002$\u0005\u001d\u0002BBA\u0013\u0019\u0001\u0007Q)A\u0004oK^dUM\u001a;\t\r\u0005%B\u00021\u0001F\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$R!TA\u0018\u0003cAqaQ\u0007\u0011\u0002\u0003\u0007Q\tC\u0004J\u001bA\u0005\t\u0019A#\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0007\u0016\u0004\u000b\u0006e2FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015C(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0015\u0011\t\u0005M\u0013QL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005!A.\u00198h\u0015\t\tY&\u0001\u0003kCZ\f\u0017\u0002BA\u000e\u0003+\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002p\u0003KB\u0001\"a\u001a\u0013\u0003\u0003\u0005\rA[\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0004#BA8\u0003kzWBAA9\u0015\r\t\u0019\bP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA<\u0003c\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QPAB!\rY\u0014qP\u0005\u0004\u0003\u0003c$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003O\"\u0012\u0011!a\u0001_\u00061Q-];bYN$B!! \u0002\n\"A\u0011qM\u000b\u0002\u0002\u0003\u0007q\u000eK\n\u0001\u0003\u001b\u000b\u0019*!&\u0002\u001a\u0006m\u0015qTAQ\u0003K\u000b9\u000bE\u0002.\u0003\u001fK1!!%\u001f\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a&\u0002\u0003OS\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(\u000f\f\u0011q_NL\u0003%\f\u0011SKR,(O\\:!i\",\u0007E^1mk\u0016\u0004sN\u001a\u0011uQ\u0016\u0004#-\u001b;!QA\u0002sN\u001d\u00112S\u0001\nG\u000f\t;iK\u0002\u001a\b/Z2jM&,G\r\t9pg&$\u0018n\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!)\",\u0007\u0005]8tSRLwN\\:!CJ,\u0007E\\;nE\u0016\u0014X\r\u001a\u0011ge>l\u0007E]5hQR\u0004Co\u001c\u0011mK\u001a$H\u0006I:uCJ$\u0018N\\4!CR\u0004#0\u001a:p])\u0001\u0003\u0005\t\u0011!AQCW\r\t9pg&$\u0018n\u001c8!CJ<W/\\3oi\u0002\u001a\u0017M\u001c8pi\u0002\u0012W\r\t8fO\u0006$\u0018N^3/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0015a\u0018\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cEb\u0003\u0005M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&M\u0019-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019\u000bA\u0001\nQa]5oG\u0016\f#!a)\u0002\u000bMr#G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005%\u0016!\u00042ji^L7/Z0gk:\u001c7/\u0001\u0006CSR<\u0018n]3HKR\u0004\"!L\f\u0014\t]\t\t\f\u0011\t\b\u0003g\u000bI,R#N\u001b\t\t)LC\u0002\u00028r\nqA];oi&lW-\u0003\u0003\u0002<\u0006U&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011QV\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011K\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u001b\u0006\u001d\u0017\u0011\u001a\u0005\u0006\u0007j\u0001\r!\u0012\u0005\u0006\u0013j\u0001\r!R\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty-a7\u0011\u000bm\n\t.!6\n\u0007\u0005MGH\u0001\u0004PaRLwN\u001c\t\u0006w\u0005]W)R\u0005\u0004\u00033d$A\u0002+va2,'\u0007\u0003\u0005\u0002^n\t\t\u00111\u0001N\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002dB!\u00111KAs\u0013\u0011\t9/!\u0016\u0003\r=\u0013'.Z2u\u0001")
public class BitwiseGet
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private int bitSize;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(BitwiseGet bitwiseGet) {
        return BitwiseGet$.MODULE$.unapply(bitwiseGet);
    }

    public static Function1<Tuple2<Expression, Expression>, BitwiseGet> tupled() {
        return BitwiseGet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, BitwiseGet>> curried() {
        return BitwiseGet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)IntegralType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return ByteType$.MODULE$;
    }

    private int bitSize$lzycompute() {
        BitwiseGet bitwiseGet = this;
        synchronized (bitwiseGet) {
            if (!this.bitmap$0) {
                int n;
                DataType dataType = this.left().dataType();
                if (ByteType$.MODULE$.equals(dataType)) {
                    n = 8;
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    n = 16;
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    n = 32;
                } else if (LongType$.MODULE$.equals(dataType)) {
                    n = 64;
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.bitSize = n;
                this.bitmap$0 = true;
            }
        }
        return this.bitSize;
    }

    public int bitSize() {
        return !this.bitmap$0 ? this.bitSize$lzycompute() : this.bitSize;
    }

    @Override
    public Object nullSafeEval(Object target, Object pos) {
        int posInt = BoxesRunTime.unboxToInt((Object)pos);
        BitwiseGetUtil$.MODULE$.checkPosition(posInt, this.bitSize());
        return BoxesRunTime.boxToByte((byte)((byte)(((Number)target).longValue() >> posInt & 1L)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(target, pos) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n         |org.apache.spark.sql.catalyst.expressions.BitwiseGetUtil.checkPosition(").append((String)pos).append(", ").append(this.bitSize()).append(");\n         |").append(ev.value()).append(" = (byte) ((((long) ").append((String)target).append(") >> ").append((String)pos).append(") & 1);\n       ").toString())).stripMargin());
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "bit_get");
    }

    @Override
    public BitwiseGet withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public BitwiseGet copy(Expression left, Expression right) {
        return new BitwiseGet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "BitwiseGet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseGet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseGet)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseGet bitwiseGet = (BitwiseGet)x$1;
        Expression expression = this.left();
        Expression expression2 = bitwiseGet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = bitwiseGet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!bitwiseGet.canEqual(this)) return false;
        return true;
    }

    public BitwiseGet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

