/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

@NotThreadSafe
public class CheckpointMetricsBuilder {
    private CompletableFuture<Long> bytesProcessedDuringAlignment = new CompletableFuture();
    private long bytesPersistedDuringAlignment = -1L;
    private CompletableFuture<Long> alignmentDurationNanos = new CompletableFuture();
    private long syncDurationMillis = -1L;
    private long asyncDurationMillis = -1L;
    private long checkpointStartDelayNanos = -1L;
    private long totalBytesPersisted = -1L;
    private long bytesPersistedOfThisCheckpoint = -1L;

    public CheckpointMetricsBuilder setBytesProcessedDuringAlignment(long bytesProcessedDuringAlignment) {
        Preconditions.checkState((boolean)this.bytesProcessedDuringAlignment.complete(bytesProcessedDuringAlignment), (Object)"bytesProcessedDuringAlignment has already been completed by someone else");
        return this;
    }

    public CheckpointMetricsBuilder setBytesProcessedDuringAlignment(CompletableFuture<Long> bytesProcessedDuringAlignment) {
        this.bytesProcessedDuringAlignment = bytesProcessedDuringAlignment;
        return this;
    }

    public CompletableFuture<Long> getBytesProcessedDuringAlignment() {
        return this.bytesProcessedDuringAlignment;
    }

    public CheckpointMetricsBuilder setBytesPersistedDuringAlignment(long bytesPersistedDuringAlignment) {
        this.bytesPersistedDuringAlignment = bytesPersistedDuringAlignment;
        return this;
    }

    public long getAlignmentDurationNanosOrDefault() {
        return (Long)FutureUtils.getOrDefault(this.alignmentDurationNanos, (Object)-1L);
    }

    public CheckpointMetricsBuilder setAlignmentDurationNanos(long alignmentDurationNanos) {
        Preconditions.checkState((boolean)this.alignmentDurationNanos.complete(alignmentDurationNanos), (Object)"alignmentDurationNanos has already been completed by someone else");
        return this;
    }

    public CheckpointMetricsBuilder setAlignmentDurationNanos(CompletableFuture<Long> alignmentDurationNanos) {
        Preconditions.checkState((!this.alignmentDurationNanos.isDone() ? 1 : 0) != 0, (Object)"alignmentDurationNanos has already been completed by someone else");
        this.alignmentDurationNanos = alignmentDurationNanos;
        return this;
    }

    public CompletableFuture<Long> getAlignmentDurationNanos() {
        return this.alignmentDurationNanos;
    }

    public CheckpointMetricsBuilder setSyncDurationMillis(long syncDurationMillis) {
        this.syncDurationMillis = syncDurationMillis;
        return this;
    }

    public long getSyncDurationMillis() {
        return this.syncDurationMillis;
    }

    public CheckpointMetricsBuilder setAsyncDurationMillis(long asyncDurationMillis) {
        this.asyncDurationMillis = asyncDurationMillis;
        return this;
    }

    public long getAsyncDurationMillis() {
        return this.asyncDurationMillis;
    }

    public CheckpointMetricsBuilder setCheckpointStartDelayNanos(long checkpointStartDelayNanos) {
        this.checkpointStartDelayNanos = checkpointStartDelayNanos;
        return this;
    }

    public long getCheckpointStartDelayNanos() {
        return this.checkpointStartDelayNanos;
    }

    public CheckpointMetricsBuilder setTotalBytesPersisted(long totalBytesPersisted) {
        this.totalBytesPersisted = totalBytesPersisted;
        return this;
    }

    public long getBytesPersistedOfThisCheckpoint() {
        return this.bytesPersistedOfThisCheckpoint;
    }

    public CheckpointMetricsBuilder setBytesPersistedOfThisCheckpoint(long bytesPersistedOfThisCheckpoint) {
        this.bytesPersistedOfThisCheckpoint = bytesPersistedOfThisCheckpoint;
        return this;
    }

    public CheckpointMetrics build() {
        return new CheckpointMetrics((Long)FutureUtils.checkStateAndGet(this.bytesProcessedDuringAlignment), this.bytesPersistedDuringAlignment, (Long)FutureUtils.checkStateAndGet(this.alignmentDurationNanos), this.syncDurationMillis, this.asyncDurationMillis, this.checkpointStartDelayNanos, this.bytesPersistedDuringAlignment > 0L, this.bytesPersistedOfThisCheckpoint, this.totalBytesPersisted);
    }

    public CheckpointMetrics buildIncomplete() {
        return new CheckpointMetrics(this.bytesProcessedDuringAlignment.getNow(-1L), this.bytesPersistedDuringAlignment, this.alignmentDurationNanos.getNow(-1L), this.syncDurationMillis, this.asyncDurationMillis, this.checkpointStartDelayNanos, this.bytesPersistedDuringAlignment > 0L, this.bytesPersistedOfThisCheckpoint, this.totalBytesPersisted);
    }
}

