/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.ResultPartitionBytes;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.scheduler.adaptivebatch.BlockingResultInfo;
import org.apache.flink.util.Preconditions;

abstract class AbstractBlockingResultInfo
implements BlockingResultInfo {
    private final IntermediateDataSetID resultId;
    protected final int numOfPartitions;
    protected final int numOfSubpartitions;
    protected final Map<Integer, long[]> subpartitionBytesByPartitionIndex;

    AbstractBlockingResultInfo(IntermediateDataSetID resultId, int numOfPartitions, int numOfSubpartitions) {
        this.resultId = (IntermediateDataSetID)Preconditions.checkNotNull((Object)resultId);
        this.numOfPartitions = numOfPartitions;
        this.numOfSubpartitions = numOfSubpartitions;
        this.subpartitionBytesByPartitionIndex = new HashMap<Integer, long[]>();
    }

    @Override
    public IntermediateDataSetID getResultId() {
        return this.resultId;
    }

    @Override
    public void recordPartitionInfo(int partitionIndex, ResultPartitionBytes partitionBytes) {
        Preconditions.checkState((partitionBytes.getSubpartitionBytes().length == this.numOfSubpartitions ? 1 : 0) != 0);
        this.subpartitionBytesByPartitionIndex.put(partitionIndex, partitionBytes.getSubpartitionBytes());
    }

    @Override
    public void resetPartitionInfo(int partitionIndex) {
        this.subpartitionBytesByPartitionIndex.remove(partitionIndex);
    }

    @VisibleForTesting
    int getNumOfRecordedPartitions() {
        return this.subpartitionBytesByPartitionIndex.size();
    }
}

