/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.Arrays;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.scheduler.adaptivebatch.AbstractBlockingResultInfo;
import org.apache.flink.util.Preconditions;

public class PointwiseBlockingResultInfo
extends AbstractBlockingResultInfo {
    PointwiseBlockingResultInfo(IntermediateDataSetID resultId, int numOfPartitions, int numOfSubpartitions) {
        super(resultId, numOfPartitions, numOfSubpartitions);
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public boolean isPointwise() {
        return true;
    }

    @Override
    public int getNumPartitions() {
        return this.numOfPartitions;
    }

    @Override
    public int getNumSubpartitions(int partitionIndex) {
        return this.numOfSubpartitions;
    }

    @Override
    public long getNumBytesProduced() {
        Preconditions.checkState((this.subpartitionBytesByPartitionIndex.size() == this.numOfPartitions ? 1 : 0) != 0, (Object)"Not all partition infos are ready");
        return this.subpartitionBytesByPartitionIndex.values().stream().flatMapToLong(Arrays::stream).reduce(0L, Long::sum);
    }

    @Override
    public long getNumBytesProduced(IndexRange partitionIndexRange, IndexRange subpartitionIndexRange) {
        long inputBytes = 0L;
        for (int i = partitionIndexRange.getStartIndex(); i <= partitionIndexRange.getEndIndex(); ++i) {
            Preconditions.checkState((this.subpartitionBytesByPartitionIndex.get(i) != null ? 1 : 0) != 0, (String)"Partition index %s is not ready.", (Object[])new Object[]{i});
            Preconditions.checkState((subpartitionIndexRange.getEndIndex() < ((long[])this.subpartitionBytesByPartitionIndex.get(i)).length ? 1 : 0) != 0, (String)"Subpartition end index %s is out of range of partition %s.", (Object[])new Object[]{subpartitionIndexRange.getEndIndex(), i});
            for (int j = subpartitionIndexRange.getStartIndex(); j <= subpartitionIndexRange.getEndIndex(); ++j) {
                inputBytes += ((long[])this.subpartitionBytesByPartitionIndex.get(i))[j];
            }
        }
        return inputBytes;
    }
}

