/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Arrays;
import java.util.NoSuchElementException;

public class IntArrayList {
    private int size = 0;
    private int[] array;
    public static final IntArrayList EMPTY = new IntArrayList(0){

        @Override
        public boolean add(int number) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeLast() {
            throw new UnsupportedOperationException();
        }
    };

    public IntArrayList(int capacity) {
        this.array = new int[capacity];
    }

    public int size() {
        return this.size;
    }

    public boolean add(int number) {
        this.grow(this.size + 1);
        this.array[this.size++] = number;
        return true;
    }

    public int removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        return this.array[this.size];
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void grow(int length) {
        if (length > this.array.length) {
            int newLength = (int)Math.max(Math.min(2L * (long)this.array.length, 0x7FFFFFF7L), (long)length);
            int[] t = new int[newLength];
            System.arraycopy(this.array, 0, t, 0, this.size);
            this.array = t;
        }
    }

    public int[] toArray() {
        return Arrays.copyOf(this.array, this.size);
    }
}

