/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.waiters.DefaultDynamoDbAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
public interface DynamoDbAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeTableResponse>> waitUntilTableExists(DescribeTableRequest describeTableRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTableResponse>> waitUntilTableExists(Consumer<DescribeTableRequest.Builder> describeTableRequest) {
        return this.waitUntilTableExists((DescribeTableRequest)((Object)((DescribeTableRequest.Builder)DescribeTableRequest.builder().applyMutation(describeTableRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeTableResponse>> waitUntilTableExists(DescribeTableRequest describeTableRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTableResponse>> waitUntilTableExists(Consumer<DescribeTableRequest.Builder> describeTableRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilTableExists((DescribeTableRequest)((Object)((DescribeTableRequest.Builder)DescribeTableRequest.builder().applyMutation(describeTableRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeTableResponse>> waitUntilTableNotExists(DescribeTableRequest describeTableRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTableResponse>> waitUntilTableNotExists(Consumer<DescribeTableRequest.Builder> describeTableRequest) {
        return this.waitUntilTableNotExists((DescribeTableRequest)((Object)((DescribeTableRequest.Builder)DescribeTableRequest.builder().applyMutation(describeTableRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeTableResponse>> waitUntilTableNotExists(DescribeTableRequest describeTableRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTableResponse>> waitUntilTableNotExists(Consumer<DescribeTableRequest.Builder> describeTableRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilTableNotExists((DescribeTableRequest)((Object)((DescribeTableRequest.Builder)DescribeTableRequest.builder().applyMutation(describeTableRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultDynamoDbAsyncWaiter.builder();
    }

    public static DynamoDbAsyncWaiter create() {
        return DefaultDynamoDbAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(DynamoDbAsyncClient var1);

        public DynamoDbAsyncWaiter build();
    }
}

