/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.Schema;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedSchemaUpdate
implements UpdateSchema {
    private static final Logger LOG = LoggerFactory.getLogger(KeyedSchemaUpdate.class);
    public static final String DOT = ".";
    private final KeyedTable keyedTable;
    private final UpdateSchema baseTableUpdateSchema;
    private final UpdateSchema changeTableUpdateSchema;

    public KeyedSchemaUpdate(KeyedTable keyedTable) {
        this.keyedTable = keyedTable;
        this.baseTableUpdateSchema = keyedTable.baseTable().updateSchema();
        this.changeTableUpdateSchema = keyedTable.changeTable().updateSchema();
    }

    public KeyedSchemaUpdate allowIncompatibleChanges() {
        this.baseTableUpdateSchema.allowIncompatibleChanges();
        this.changeTableUpdateSchema.allowIncompatibleChanges();
        return this;
    }

    public UpdateSchema addColumn(String name, Type type, String doc) {
        this.baseTableUpdateSchema.addColumn(name, type, doc);
        this.changeTableUpdateSchema.addColumn(name, type, doc);
        return this;
    }

    public UpdateSchema addColumn(String parent, String name, Type type, String doc) {
        this.baseTableUpdateSchema.addColumn(parent, name, type, doc);
        this.changeTableUpdateSchema.addColumn(parent, name, type, doc);
        return this;
    }

    public UpdateSchema addRequiredColumn(String name, Type type, String doc) {
        this.baseTableUpdateSchema.addRequiredColumn(name, type, doc);
        this.changeTableUpdateSchema.addRequiredColumn(name, type, doc);
        return this;
    }

    public UpdateSchema addRequiredColumn(String parent, String name, Type type, String doc) {
        this.baseTableUpdateSchema.addRequiredColumn(parent, name, type, doc);
        this.changeTableUpdateSchema.addRequiredColumn(parent, name, type, doc);
        return this;
    }

    public UpdateSchema deleteColumn(String name) {
        Preconditions.checkArgument((!this.containsPk(name) ? 1 : 0) != 0, (String)"Cannot delete primary key. %s", (Object)name);
        this.baseTableUpdateSchema.deleteColumn(name);
        this.changeTableUpdateSchema.deleteColumn(name);
        return this;
    }

    public UpdateSchema renameColumn(String name, String newName) {
        Preconditions.checkArgument((!this.containsPk(name) ? 1 : 0) != 0, (String)"Cannot rename primary key %s", (Object)name);
        this.baseTableUpdateSchema.renameColumn(name, newName);
        this.changeTableUpdateSchema.renameColumn(name, newName);
        return this;
    }

    public UpdateSchema requireColumn(String name) {
        this.baseTableUpdateSchema.requireColumn(name);
        this.changeTableUpdateSchema.requireColumn(name);
        return this;
    }

    public UpdateSchema makeColumnOptional(String name) {
        Preconditions.checkArgument((!this.containsPk(name) ? 1 : 0) != 0, (String)"Cannot make primary key optional. %s", (Object)name);
        this.baseTableUpdateSchema.makeColumnOptional(name);
        this.changeTableUpdateSchema.makeColumnOptional(name);
        return this;
    }

    public UpdateSchema updateColumn(String name, Type.PrimitiveType newType) {
        this.baseTableUpdateSchema.updateColumn(name, newType);
        this.changeTableUpdateSchema.updateColumn(name, newType);
        return this;
    }

    public UpdateSchema updateColumnDoc(String name, String doc) {
        this.baseTableUpdateSchema.updateColumnDoc(name, doc);
        this.changeTableUpdateSchema.updateColumnDoc(name, doc);
        return this;
    }

    public UpdateSchema moveFirst(String name) {
        this.baseTableUpdateSchema.moveFirst(name);
        this.changeTableUpdateSchema.moveFirst(name);
        return this;
    }

    public UpdateSchema moveBefore(String name, String beforeName) {
        this.baseTableUpdateSchema.moveBefore(name, beforeName);
        this.changeTableUpdateSchema.moveBefore(name, beforeName);
        return this;
    }

    public UpdateSchema moveAfter(String name, String afterName) {
        this.baseTableUpdateSchema.moveAfter(name, afterName);
        this.changeTableUpdateSchema.moveAfter(name, afterName);
        return this;
    }

    public UpdateSchema unionByNameWith(Schema newSchema) {
        this.baseTableUpdateSchema.unionByNameWith(newSchema);
        this.changeTableUpdateSchema.unionByNameWith(newSchema);
        return this;
    }

    public UpdateSchema setIdentifierFields(Collection<String> names) {
        throw new UnsupportedOperationException("Mixed-format tables do not support setting identifier files.");
    }

    public Schema apply() {
        KeyedSchemaUpdate.syncSchema(this.keyedTable);
        Schema newSchema = (Schema)this.baseTableUpdateSchema.apply();
        this.changeTableUpdateSchema.apply();
        return newSchema;
    }

    public void commit() {
        this.baseTableUpdateSchema.commit();
        try {
            this.changeTableUpdateSchema.commit();
        }
        catch (Exception e) {
            LOG.warn("change table schema commit exception", (Throwable)e);
        }
    }

    private boolean containsPk(String name) {
        if (!this.keyedTable.primaryKeySpec().primaryKeyExisted()) {
            return false;
        }
        return this.keyedTable.primaryKeySpec().fieldNames().contains(name);
    }

    public static void syncSchema(KeyedTable keyedTable) {
        int changeSchemaSize;
        if (PrimaryKeySpec.noPrimaryKey().equals(keyedTable.primaryKeySpec())) {
            return;
        }
        int baseSchemaSize = keyedTable.baseTable().schemas().size();
        if (baseSchemaSize <= (changeSchemaSize = keyedTable.changeTable().schemas().size())) {
            return;
        }
        if (baseSchemaSize == changeSchemaSize + 1) {
            Schema newer = keyedTable.baseTable().schema();
            KeyedSchemaUpdate.syncSchema(newer, keyedTable.changeTable().schema(), keyedTable.changeTable().updateSchema());
            return;
        }
        throw new IllegalStateException("base table have two more versions than change table");
    }

    private static void syncSchema(Schema newer, Schema old, UpdateSchema changeTableUs) {
        PriorityQueue<Add> adds = new PriorityQueue<Add>();
        for (Types.NestedField newField : newer.columns()) {
            Types.NestedField oldField = old.findField(newField.fieldId());
            KeyedSchemaUpdate.syncField(newField, oldField, changeTableUs, null, adds);
        }
        old.columns().forEach(c -> {
            if (newer.findField(c.fieldId()) == null) {
                KeyedSchemaUpdate.syncField(null, c, changeTableUs, null, adds);
            }
        });
        KeyedSchemaUpdate.doAddColumns(adds, changeTableUs);
        LOG.info("sync schema to changeTable. from: {}, base: {}, actual: {}", new Object[]{old, newer, changeTableUs.apply()});
        changeTableUs.commit();
    }

    private static void syncField(Types.NestedField newField, Types.NestedField oldField, UpdateSchema us, String fieldPrefix, Collection<Add> adds) {
        if (oldField == null && newField == null) {
            return;
        }
        if (oldField == null) {
            KeyedSchemaUpdate.addColumnInternal(newField, fieldPrefix, adds);
            return;
        }
        if (newField == null) {
            KeyedSchemaUpdate.deleteColumnInternal(oldField.name(), us, fieldPrefix);
            return;
        }
        if (Objects.equals(newField, oldField)) {
            return;
        }
        KeyedSchemaUpdate.updateField(newField, oldField, us, fieldPrefix, adds);
    }

    private static void doAddColumns(PriorityQueue<Add> adds, UpdateSchema us) {
        while (!adds.isEmpty()) {
            Add add = adds.poll();
            if (StringUtils.isBlank((CharSequence)add.parent)) {
                us.addColumn(add.field, add.type, add.doc);
                continue;
            }
            if (add.parent.contains(DOT)) {
                LOG.error("field: {}", (Object)add);
                throw new UnsupportedOperationException("do not support add deeper than two nested field");
            }
            us.addColumn(add.parent, add.field, add.type, add.doc);
        }
    }

    private static void addColumnInternal(Types.NestedField field, String fieldPrefix, Collection<Add> adds) {
        adds.add(new Add(field, fieldPrefix));
    }

    private static void deleteColumnInternal(String field, UpdateSchema changeTableUs, String fieldPrefix) {
        changeTableUs.deleteColumn(KeyedSchemaUpdate.getFullName(fieldPrefix, field));
    }

    private static String getFullName(String fieldPrefix, String field) {
        return StringUtils.isBlank((CharSequence)fieldPrefix) ? field : String.join((CharSequence)DOT, fieldPrefix, field);
    }

    private static void updateField(Types.NestedField newField, Types.NestedField oldField, UpdateSchema us, String fieldPrefix, Collection<Add> adds) {
        String oldFullFieldName = KeyedSchemaUpdate.getFullName(fieldPrefix, oldField.name());
        if (!Objects.equals(newField.doc(), oldField.doc())) {
            us.updateColumnDoc(oldFullFieldName, newField.doc());
        }
        if (!Objects.equals(newField.isRequired(), oldField.isRequired())) {
            if (newField.isRequired()) {
                us.requireColumn(oldFullFieldName);
            } else {
                us.makeColumnOptional(oldFullFieldName);
            }
        }
        if (!Objects.equals(newField.name(), oldField.name())) {
            us.renameColumn(oldFullFieldName, newField.name());
        }
        if (newField.type().isPrimitiveType()) {
            KeyedSchemaUpdate.updatePrimativeFieldType(newField, oldField, us, fieldPrefix);
        } else {
            KeyedSchemaUpdate.updateNestedField(newField, oldField, us, fieldPrefix, adds);
        }
    }

    private static void updateNestedField(Types.NestedField newField, Types.NestedField oldField, UpdateSchema us, String fieldPrefix, Collection<Add> adds) {
        if (oldField.type().isMapType()) {
            KeyedSchemaUpdate.updateMapField(newField, oldField, us, fieldPrefix, adds);
            return;
        }
        Type.NestedType newType = newField.type().asNestedType();
        Type.NestedType oldType = oldField.type().asNestedType();
        String prefix = KeyedSchemaUpdate.getFullName(fieldPrefix, oldField.name());
        KeyedSchemaUpdate.updateNestedField(newType, oldType, us, prefix, adds);
    }

    private static void updateNestedField(Type.NestedType newType, Type.NestedType oldType, UpdateSchema us, String fieldPrefix, Collection<Add> adds) {
        if (Objects.equals(newType, oldType)) {
            return;
        }
        newType.fields().forEach(field -> {
            Types.NestedField old = oldType.field(field.fieldId());
            KeyedSchemaUpdate.syncField(field, old, us, fieldPrefix, adds);
        });
        oldType.fields().forEach(o -> {
            if (newType.field(o.fieldId()) == null) {
                KeyedSchemaUpdate.syncField(null, o, us, fieldPrefix, adds);
            }
        });
    }

    private static void updateMapField(Types.NestedField newField, Types.NestedField oldField, UpdateSchema us, String fieldPrefix, Collection<Add> adds) {
        Types.MapType newType = newField.type().asMapType();
        Types.MapType oldType = oldField.type().asMapType();
        List newFields = newType.fields();
        List oldFields = oldType.fields();
        String crtPrefix = KeyedSchemaUpdate.getFullName(fieldPrefix, oldField.name());
        for (int i = 0; i < newFields.size(); ++i) {
            Types.NestedField newF = (Types.NestedField)newFields.get(i);
            Types.NestedField oldF = (Types.NestedField)oldFields.get(i);
            Type t = newF.type();
            if (t.isPrimitiveType()) {
                KeyedSchemaUpdate.syncField(newF, oldF, us, crtPrefix, adds);
                continue;
            }
            KeyedSchemaUpdate.updateNestedField(newF.type().asNestedType(), oldF.type().asNestedType(), us, crtPrefix, adds);
        }
    }

    private static void updatePrimativeFieldType(Types.NestedField newField, Types.NestedField oldField, UpdateSchema us, String fieldPrefix) {
        String fullName = KeyedSchemaUpdate.getFullName(fieldPrefix, oldField.name());
        if (!Objects.equals(newField.type(), oldField.type())) {
            us.updateColumn(fullName, newField.type().asPrimitiveType());
        }
    }

    static class Add
    implements Comparable<Add>,
    Serializable {
        private final int baseFieldId;
        private final String parent;
        private final String field;
        private final Type type;
        private final String doc;

        public Add(Types.NestedField field, String parent) {
            this(field.fieldId(), parent, field.name(), field.type(), field.doc());
        }

        public Add(int baseFieldId, String parent, String field, Type type, String doc) {
            this.baseFieldId = baseFieldId;
            this.parent = parent;
            this.field = field;
            this.type = type;
            this.doc = doc;
        }

        @Override
        public int compareTo(@Nonnull Add o) {
            return this.baseFieldId - o.baseFieldId;
        }

        public String toString() {
            return "Add{baseFieldId=" + this.baseFieldId + ", parent='" + this.parent + '\'' + ", field='" + this.field + '\'' + ", type=" + this.type + ", doc='" + this.doc + '\'' + '}';
        }
    }
}

