/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils.map;

import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.utils.SerializationUtil;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;

public class StructLikeWrapperSerializer
implements SerializationUtil.SimpleSerializer<StructLikeWrapper> {
    protected final StructLikeWrapper structLikeWrapper;

    public StructLikeWrapperSerializer(StructLikeWrapper structLikeWrapper) {
        this.structLikeWrapper = structLikeWrapper;
    }

    public StructLikeWrapperSerializer(Types.StructType type) {
        this.structLikeWrapper = StructLikeWrapper.forType((Types.StructType)type);
    }

    public byte[] serialize(StructLikeWrapper structLikeWrapper) {
        Preconditions.checkNotNull((Object)structLikeWrapper);
        StructLike copy = StructLikeCopy.copy(structLikeWrapper.get());
        return SerializationUtil.kryoSerialize((Object)copy);
    }

    public StructLikeWrapper deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StructLikeCopy structLike = (StructLikeCopy)SerializationUtil.kryoDeserialize((byte[])bytes);
        return this.structLikeWrapper.copyFor((StructLike)structLike);
    }

    public static class StructLikeCopy
    implements StructLike {
        private final Object[] values;

        public static StructLike copy(StructLike struct) {
            return struct != null ? new StructLikeCopy(struct) : null;
        }

        private StructLikeCopy(StructLike toCopy) {
            this.values = new Object[toCopy.size()];
            for (int i = 0; i < this.values.length; ++i) {
                Object value = toCopy.get(i, Object.class);
                this.values[i] = value instanceof StructLike ? StructLikeCopy.copy((StructLike)value) : value;
            }
        }

        public int size() {
            return this.values.length;
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.values[pos]);
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Struct copy cannot be modified");
        }
    }
}

