/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.CompressionKind;
import org.apache.orc.DataMaskDescription;
import org.apache.orc.EncryptionAlgorithm;
import org.apache.orc.EncryptionKey;
import org.apache.orc.EncryptionVariant;
import org.apache.orc.FileMetadata;
import org.apache.orc.MemoryManager;
import org.apache.orc.OrcConf;
import org.apache.orc.PhysicalWriter;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.StripeStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.HadoopShimsFactory;
import org.apache.orc.impl.KeyProvider;
import org.apache.orc.impl.MemoryManagerImpl;
import org.apache.orc.impl.OrcTail;
import org.apache.orc.impl.ReaderImpl;
import org.apache.orc.impl.WriterImpl;
import org.apache.orc.impl.WriterInternal;
import org.apache.orc.impl.writer.WriterImplV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFile {
    private static final Logger LOG = LoggerFactory.getLogger(OrcFile.class);
    public static final String MAGIC = "ORC";
    public static final WriterVersion CURRENT_WRITER = WriterVersion.ORC_14;
    private static MemoryManager memoryManager = null;

    protected OrcFile() {
    }

    public static ReaderOptions readerOptions(Configuration conf) {
        return new ReaderOptions(conf);
    }

    public static Reader createReader(Path path, ReaderOptions options) throws IOException {
        return new ReaderImpl(path, options);
    }

    public static WriterOptions writerOptions(Configuration conf) {
        return new WriterOptions(null, conf);
    }

    public static WriterOptions writerOptions(Properties tableProperties, Configuration conf) {
        return new WriterOptions(tableProperties, conf);
    }

    private static synchronized MemoryManager getStaticMemoryManager(Configuration conf) {
        if (memoryManager == null) {
            memoryManager = new MemoryManagerImpl(conf);
        }
        return memoryManager;
    }

    public static Writer createWriter(Path path, WriterOptions opts) throws IOException {
        FileSystem fs = opts.getFileSystem() == null ? path.getFileSystem(opts.getConfiguration()) : opts.getFileSystem();
        switch (opts.getVersion()) {
            case V_0_11: 
            case V_0_12: {
                return new WriterImpl(fs, path, opts);
            }
            case UNSTABLE_PRE_2_0: {
                return new WriterImplV2(fs, path, opts);
            }
        }
        throw new IllegalArgumentException("Unknown version " + (Object)((Object)opts.getVersion()));
    }

    static boolean understandFormat(Path path, Reader reader) {
        if (reader.getFileVersion() == Version.FUTURE) {
            LOG.info("Can't merge {} because it has a future version.", (Object)path);
            return false;
        }
        if (reader.getWriterVersion() == WriterVersion.FUTURE) {
            LOG.info("Can't merge {} because it has a future writerVersion.", (Object)path);
            return false;
        }
        return true;
    }

    private static boolean sameKeys(EncryptionKey[] first, EncryptionKey[] next) {
        if (first.length != next.length) {
            return false;
        }
        for (int k = 0; k < first.length; ++k) {
            if (first[k].getKeyName().equals(next[k].getKeyName()) && first[k].getKeyVersion() == next[k].getKeyVersion() && first[k].getAlgorithm() == next[k].getAlgorithm()) continue;
            return false;
        }
        return true;
    }

    private static boolean sameMasks(DataMaskDescription[] first, DataMaskDescription[] next) {
        if (first.length != next.length) {
            return false;
        }
        for (int k = 0; k < first.length; ++k) {
            TypeDescription[] nextRoots;
            String[] nextParam;
            if (!first[k].getName().equals(next[k].getName())) {
                return false;
            }
            String[] firstParam = first[k].getParameters();
            if (firstParam.length != (nextParam = next[k].getParameters()).length) {
                return false;
            }
            for (int p = 0; p < firstParam.length; ++p) {
                if (firstParam[p].equals(nextParam[p])) continue;
                return false;
            }
            TypeDescription[] firstRoots = first[k].getColumns();
            if (firstRoots.length != (nextRoots = next[k].getColumns()).length) {
                return false;
            }
            for (int r = 0; r < firstRoots.length; ++r) {
                if (firstRoots[r].getId() == nextRoots[r].getId()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean sameVariants(EncryptionVariant[] first, EncryptionVariant[] next) {
        if (first.length != next.length) {
            return false;
        }
        for (int k = 0; k < first.length; ++k) {
            if (first[k].getKeyDescription() == null == (next[k].getKeyDescription() == null) && first[k].getKeyDescription().getKeyName().equals(next[k].getKeyDescription().getKeyName()) && first[k].getRoot().getId() == next[k].getRoot().getId()) continue;
            return false;
        }
        return true;
    }

    static boolean readerIsCompatible(Reader firstReader, Map<String, ByteBuffer> userMetadata, Path path, Reader reader) {
        TypeDescription schema = firstReader.getSchema();
        if (!reader.getSchema().equals(schema)) {
            LOG.info("Can't merge {} because of different schemas {} vs {}", new Object[]{path, reader.getSchema(), schema});
            return false;
        }
        CompressionKind compression = firstReader.getCompressionKind();
        if (reader.getCompressionKind() != compression) {
            LOG.info("Can't merge {} because of different compression {} vs {}", new Object[]{path, reader.getCompressionKind(), compression});
            return false;
        }
        Version fileVersion = firstReader.getFileVersion();
        if (reader.getFileVersion() != fileVersion) {
            LOG.info("Can't merge {} because of different file versions {} vs {}", new Object[]{path, reader.getFileVersion(), fileVersion});
            return false;
        }
        WriterVersion writerVersion = firstReader.getWriterVersion();
        if (reader.getWriterVersion() != writerVersion) {
            LOG.info("Can't merge {} because of different writer versions {} vs {}", new Object[]{path, reader.getFileVersion(), fileVersion});
            return false;
        }
        int rowIndexStride = firstReader.getRowIndexStride();
        if (reader.getRowIndexStride() != rowIndexStride) {
            LOG.info("Can't merge {} because of different row index strides {} vs {}", new Object[]{path, reader.getRowIndexStride(), rowIndexStride});
            return false;
        }
        for (String key : reader.getMetadataKeys()) {
            ByteBuffer newValue;
            ByteBuffer currentValue = userMetadata.get(key);
            if (currentValue == null || (newValue = reader.getMetadataValue(key)).equals(currentValue)) continue;
            LOG.info("Can't merge {} because of different user metadata {}", (Object)path, (Object)key);
            return false;
        }
        if (!OrcFile.sameKeys(firstReader.getColumnEncryptionKeys(), reader.getColumnEncryptionKeys())) {
            LOG.info("Can't merge {} because it has different encryption keys", (Object)path);
            return false;
        }
        if (!OrcFile.sameMasks(firstReader.getDataMasks(), reader.getDataMasks())) {
            LOG.info("Can't merge {} because it has different encryption masks", (Object)path);
            return false;
        }
        if (!OrcFile.sameVariants(firstReader.getEncryptionVariants(), reader.getEncryptionVariants())) {
            LOG.info("Can't merge {} because it has different encryption variants", (Object)path);
            return false;
        }
        if (firstReader.writerUsedProlepticGregorian() != reader.writerUsedProlepticGregorian()) {
            LOG.info("Can't merge {} because it uses a different calendar", (Object)path);
            return false;
        }
        return true;
    }

    static void mergeMetadata(Map<String, ByteBuffer> metadata, Reader reader) {
        for (String key : reader.getMetadataKeys()) {
            metadata.put(key, reader.getMetadataValue(key));
        }
    }

    public static List<Path> mergeFiles(Path outputPath, WriterOptions options, List<Path> inputFiles) throws IOException {
        Writer output = null;
        Configuration conf = options.getConfiguration();
        KeyProvider keyProvider = options.getKeyProvider();
        try {
            byte[] buffer = new byte[]{};
            Reader firstFile = null;
            ArrayList<Path> result = new ArrayList<Path>(inputFiles.size());
            HashMap<String, ByteBuffer> userMetadata = new HashMap<String, ByteBuffer>();
            int bufferSize = 0;
            for (Path path : inputFiles) {
                FileSystem fs = path.getFileSystem(conf);
                Reader reader = OrcFile.createReader(path, OrcFile.readerOptions(options.getConfiguration()).filesystem(fs).setKeyProvider(keyProvider));
                if (!OrcFile.understandFormat(path, reader)) continue;
                if (firstFile == null) {
                    firstFile = reader;
                    bufferSize = reader.getCompressionSize();
                    CompressionKind compression = reader.getCompressionKind();
                    options.bufferSize(bufferSize).version(reader.getFileVersion()).writerVersion(reader.getWriterVersion()).compress(compression).rowIndexStride(reader.getRowIndexStride()).setSchema(reader.getSchema());
                    if (compression != CompressionKind.NONE) {
                        options.enforceBufferSize().bufferSize(bufferSize);
                    }
                    OrcFile.mergeMetadata(userMetadata, reader);
                    for (EncryptionKey key : reader.getColumnEncryptionKeys()) {
                        options.setKeyVersion(key.getKeyName(), key.getKeyVersion(), key.getAlgorithm());
                    }
                    output = OrcFile.createWriter(outputPath, options);
                } else {
                    if (!OrcFile.readerIsCompatible(firstFile, userMetadata, path, reader)) continue;
                    OrcFile.mergeMetadata(userMetadata, reader);
                    if (bufferSize < reader.getCompressionSize()) {
                        bufferSize = reader.getCompressionSize();
                        ((WriterInternal)output).increaseCompressionSize(bufferSize);
                    }
                }
                EncryptionVariant[] variants = reader.getEncryptionVariants();
                List[] completeList = new List[variants.length + 1];
                for (int v = 0; v < variants.length; ++v) {
                    completeList[v] = reader.getVariantStripeStatistics(variants[v]);
                }
                completeList[completeList.length - 1] = reader.getVariantStripeStatistics(null);
                StripeStatistics[] stripeStats = new StripeStatistics[completeList.length];
                FSDataInputStream inputStream = ((ReaderImpl)reader).takeFile();
                Throwable throwable = null;
                try {
                    result.add(path);
                    for (StripeInformation stripe : reader.getStripes()) {
                        int length = (int)stripe.getLength();
                        if (buffer.length < length) {
                            buffer = new byte[length];
                        }
                        long offset = stripe.getOffset();
                        inputStream.readFully(offset, buffer, 0, length);
                        int stripeId = (int)stripe.getStripeId();
                        for (int v = 0; v < completeList.length; ++v) {
                            stripeStats[v] = (StripeStatistics)completeList[v].get(stripeId);
                        }
                        output.appendStripe(buffer, 0, length, stripe, stripeStats);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            if (output != null) {
                for (Map.Entry entry : userMetadata.entrySet()) {
                    output.addUserMetadata((String)entry.getKey(), (ByteBuffer)entry.getValue());
                }
                output.close();
            }
            return result;
        }
        catch (Throwable t) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Throwable firstFile) {
                    // empty catch block
                }
                try {
                    FileSystem fs = options.getFileSystem() == null ? outputPath.getFileSystem(conf) : options.getFileSystem();
                    fs.delete(outputPath, false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new IOException("Problem merging files into " + outputPath, t);
        }
    }

    public static class WriterOptions
    implements Cloneable {
        private final Configuration configuration;
        private FileSystem fileSystemValue = null;
        private TypeDescription schema = null;
        private long stripeSizeValue;
        private long stripeRowCountValue;
        private long blockSizeValue;
        private boolean buildIndex;
        private int rowIndexStrideValue;
        private int bufferSizeValue;
        private boolean enforceBufferSize = false;
        private boolean blockPaddingValue;
        private CompressionKind compressValue;
        private MemoryManager memoryManagerValue;
        private Version versionValue;
        private WriterCallback callback;
        private EncodingStrategy encodingStrategy;
        private CompressionStrategy compressionStrategy;
        private double paddingTolerance;
        private String bloomFilterColumns;
        private double bloomFilterFpp;
        private BloomFilterVersion bloomFilterVersion;
        private PhysicalWriter physicalWriter;
        private WriterVersion writerVersion = CURRENT_WRITER;
        private boolean useUTCTimestamp;
        private boolean overwrite;
        private boolean writeVariableLengthBlocks;
        private HadoopShims shims;
        private String directEncodingColumns;
        private String encryption;
        private String masks;
        private KeyProvider provider;
        private boolean useProlepticGregorian;
        private Map<String, HadoopShims.KeyMetadata> keyOverrides = new HashMap<String, HadoopShims.KeyMetadata>();

        protected WriterOptions(Properties tableProperties, Configuration conf) {
            this.configuration = conf;
            this.memoryManagerValue = OrcFile.getStaticMemoryManager(conf);
            this.overwrite = OrcConf.OVERWRITE_OUTPUT_FILE.getBoolean(tableProperties, conf);
            this.stripeSizeValue = OrcConf.STRIPE_SIZE.getLong(tableProperties, conf);
            this.stripeRowCountValue = OrcConf.STRIPE_ROW_COUNT.getLong(tableProperties, conf);
            this.blockSizeValue = OrcConf.BLOCK_SIZE.getLong(tableProperties, conf);
            this.buildIndex = OrcConf.ENABLE_INDEXES.getBoolean(tableProperties, conf);
            this.rowIndexStrideValue = (int)OrcConf.ROW_INDEX_STRIDE.getLong(tableProperties, conf);
            this.bufferSizeValue = (int)OrcConf.BUFFER_SIZE.getLong(tableProperties, conf);
            this.blockPaddingValue = OrcConf.BLOCK_PADDING.getBoolean(tableProperties, conf);
            this.compressValue = CompressionKind.valueOf(OrcConf.COMPRESS.getString(tableProperties, conf).toUpperCase());
            this.enforceBufferSize = OrcConf.ENFORCE_COMPRESSION_BUFFER_SIZE.getBoolean(tableProperties, conf);
            String versionName = OrcConf.WRITE_FORMAT.getString(tableProperties, conf);
            this.versionValue = Version.byName(versionName);
            String enString = OrcConf.ENCODING_STRATEGY.getString(tableProperties, conf);
            this.encodingStrategy = EncodingStrategy.valueOf(enString);
            String compString = OrcConf.COMPRESSION_STRATEGY.getString(tableProperties, conf);
            this.compressionStrategy = CompressionStrategy.valueOf(compString);
            this.paddingTolerance = OrcConf.BLOCK_PADDING_TOLERANCE.getDouble(tableProperties, conf);
            this.bloomFilterColumns = OrcConf.BLOOM_FILTER_COLUMNS.getString(tableProperties, conf);
            this.bloomFilterFpp = OrcConf.BLOOM_FILTER_FPP.getDouble(tableProperties, conf);
            this.bloomFilterVersion = BloomFilterVersion.fromString(OrcConf.BLOOM_FILTER_WRITE_VERSION.getString(tableProperties, conf));
            this.shims = HadoopShimsFactory.get();
            this.writeVariableLengthBlocks = OrcConf.WRITE_VARIABLE_LENGTH_BLOCKS.getBoolean(tableProperties, conf);
            this.directEncodingColumns = OrcConf.DIRECT_ENCODING_COLUMNS.getString(tableProperties, conf);
            this.useProlepticGregorian = OrcConf.PROLEPTIC_GREGORIAN.getBoolean(conf);
        }

        public WriterOptions clone() {
            try {
                return (WriterOptions)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError((Object)"Expected super.clone() to work");
            }
        }

        public WriterOptions fileSystem(FileSystem value) {
            this.fileSystemValue = value;
            return this;
        }

        public WriterOptions overwrite(boolean value) {
            this.overwrite = value;
            return this;
        }

        public WriterOptions stripeSize(long value) {
            this.stripeSizeValue = value;
            return this;
        }

        public WriterOptions blockSize(long value) {
            this.blockSizeValue = value;
            return this;
        }

        public WriterOptions rowIndexStride(int value) {
            this.rowIndexStrideValue = value;
            return this;
        }

        public WriterOptions bufferSize(int value) {
            this.bufferSizeValue = value;
            return this;
        }

        public WriterOptions enforceBufferSize() {
            this.enforceBufferSize = true;
            return this;
        }

        public WriterOptions blockPadding(boolean value) {
            this.blockPaddingValue = value;
            return this;
        }

        public WriterOptions encodingStrategy(EncodingStrategy strategy) {
            this.encodingStrategy = strategy;
            return this;
        }

        public WriterOptions paddingTolerance(double value) {
            this.paddingTolerance = value;
            return this;
        }

        public WriterOptions bloomFilterColumns(String columns) {
            this.bloomFilterColumns = columns;
            return this;
        }

        public WriterOptions bloomFilterFpp(double fpp) {
            this.bloomFilterFpp = fpp;
            return this;
        }

        public WriterOptions compress(CompressionKind value) {
            this.compressValue = value;
            return this;
        }

        public WriterOptions setSchema(TypeDescription schema) {
            this.schema = schema;
            return this;
        }

        public WriterOptions version(Version value) {
            this.versionValue = value;
            return this;
        }

        public WriterOptions callback(WriterCallback callback) {
            this.callback = callback;
            return this;
        }

        public WriterOptions bloomFilterVersion(BloomFilterVersion version) {
            this.bloomFilterVersion = version;
            return this;
        }

        public WriterOptions physicalWriter(PhysicalWriter writer) {
            this.physicalWriter = writer;
            return this;
        }

        public WriterOptions memory(MemoryManager value) {
            this.memoryManagerValue = value;
            return this;
        }

        public WriterOptions writeVariableLengthBlocks(boolean value) {
            this.writeVariableLengthBlocks = value;
            return this;
        }

        public WriterOptions setShims(HadoopShims value) {
            this.shims = value;
            return this;
        }

        protected WriterOptions writerVersion(WriterVersion version) {
            if (version == WriterVersion.FUTURE) {
                throw new IllegalArgumentException("Can't write a future version.");
            }
            this.writerVersion = version;
            return this;
        }

        public WriterOptions useUTCTimestamp(boolean value) {
            this.useUTCTimestamp = value;
            return this;
        }

        public WriterOptions directEncodingColumns(String value) {
            this.directEncodingColumns = value;
            return this;
        }

        public WriterOptions encrypt(String value) {
            this.encryption = value;
            return this;
        }

        public WriterOptions masks(String value) {
            this.masks = value;
            return this;
        }

        public WriterOptions setKeyVersion(String keyName, int version, EncryptionAlgorithm algorithm) {
            HadoopShims.KeyMetadata meta = new HadoopShims.KeyMetadata(keyName, version, algorithm);
            this.keyOverrides.put(keyName, meta);
            return this;
        }

        public WriterOptions setKeyProvider(KeyProvider provider) {
            this.provider = provider;
            return this;
        }

        public WriterOptions setProlepticGregorian(boolean newValue) {
            this.useProlepticGregorian = newValue;
            return this;
        }

        public KeyProvider getKeyProvider() {
            return this.provider;
        }

        public boolean getBlockPadding() {
            return this.blockPaddingValue;
        }

        public long getBlockSize() {
            return this.blockSizeValue;
        }

        public String getBloomFilterColumns() {
            return this.bloomFilterColumns;
        }

        public boolean getOverwrite() {
            return this.overwrite;
        }

        public FileSystem getFileSystem() {
            return this.fileSystemValue;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public TypeDescription getSchema() {
            return this.schema;
        }

        public long getStripeSize() {
            return this.stripeSizeValue;
        }

        public long getStripeRowCountValue() {
            return this.stripeRowCountValue;
        }

        public CompressionKind getCompress() {
            return this.compressValue;
        }

        public WriterCallback getCallback() {
            return this.callback;
        }

        public Version getVersion() {
            return this.versionValue;
        }

        public MemoryManager getMemoryManager() {
            return this.memoryManagerValue;
        }

        public int getBufferSize() {
            return this.bufferSizeValue;
        }

        public boolean isEnforceBufferSize() {
            return this.enforceBufferSize;
        }

        public int getRowIndexStride() {
            return this.rowIndexStrideValue;
        }

        public boolean isBuildIndex() {
            return this.buildIndex;
        }

        public CompressionStrategy getCompressionStrategy() {
            return this.compressionStrategy;
        }

        public EncodingStrategy getEncodingStrategy() {
            return this.encodingStrategy;
        }

        public double getPaddingTolerance() {
            return this.paddingTolerance;
        }

        public double getBloomFilterFpp() {
            return this.bloomFilterFpp;
        }

        public BloomFilterVersion getBloomFilterVersion() {
            return this.bloomFilterVersion;
        }

        public PhysicalWriter getPhysicalWriter() {
            return this.physicalWriter;
        }

        public WriterVersion getWriterVersion() {
            return this.writerVersion;
        }

        public boolean getWriteVariableLengthBlocks() {
            return this.writeVariableLengthBlocks;
        }

        public HadoopShims getHadoopShims() {
            return this.shims;
        }

        public boolean getUseUTCTimestamp() {
            return this.useUTCTimestamp;
        }

        public String getDirectEncodingColumns() {
            return this.directEncodingColumns;
        }

        public String getEncryption() {
            return this.encryption;
        }

        public String getMasks() {
            return this.masks;
        }

        public Map<String, HadoopShims.KeyMetadata> getKeyOverrides() {
            return this.keyOverrides;
        }

        public boolean getProlepticGregorian() {
            return this.useProlepticGregorian;
        }
    }

    public static enum BloomFilterVersion {
        ORIGINAL("original"),
        UTF8("utf8");

        private final String id;

        private BloomFilterVersion(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public static BloomFilterVersion fromString(String s) {
            for (BloomFilterVersion version : BloomFilterVersion.values()) {
                if (!version.id.equals(s)) continue;
                return version;
            }
            throw new IllegalArgumentException("Unknown BloomFilterVersion " + s);
        }
    }

    public static interface WriterCallback {
        public void preStripeWrite(WriterContext var1) throws IOException;

        public void preFooterWrite(WriterContext var1) throws IOException;
    }

    public static interface WriterContext {
        public Writer getWriter();
    }

    public static class ReaderOptions {
        private final Configuration conf;
        private FileSystem filesystem;
        private long maxLength = Long.MAX_VALUE;
        private OrcTail orcTail;
        private KeyProvider keyProvider;
        private FileMetadata fileMetadata;
        private boolean useUTCTimestamp;
        private boolean useProlepticGregorian;

        public ReaderOptions(Configuration conf) {
            this.conf = conf;
            this.useProlepticGregorian = OrcConf.PROLEPTIC_GREGORIAN.getBoolean(conf);
        }

        public ReaderOptions filesystem(FileSystem fs) {
            this.filesystem = fs;
            return this;
        }

        public ReaderOptions maxLength(long val) {
            this.maxLength = val;
            return this;
        }

        public ReaderOptions orcTail(OrcTail tail) {
            this.orcTail = tail;
            return this;
        }

        public ReaderOptions setKeyProvider(KeyProvider provider) {
            this.keyProvider = provider;
            return this;
        }

        public ReaderOptions convertToProlepticGregorian(boolean newValue) {
            this.useProlepticGregorian = newValue;
            return this;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public FileSystem getFilesystem() {
            return this.filesystem;
        }

        public long getMaxLength() {
            return this.maxLength;
        }

        public OrcTail getOrcTail() {
            return this.orcTail;
        }

        public KeyProvider getKeyProvider() {
            return this.keyProvider;
        }

        public ReaderOptions fileMetadata(FileMetadata metadata) {
            this.fileMetadata = metadata;
            return this;
        }

        public FileMetadata getFileMetadata() {
            return this.fileMetadata;
        }

        public ReaderOptions useUTCTimestamp(boolean value) {
            this.useUTCTimestamp = value;
            return this;
        }

        public boolean getUseUTCTimestamp() {
            return this.useUTCTimestamp;
        }

        public boolean getConvertToProlepticGregorian() {
            return this.useProlepticGregorian;
        }
    }

    public static enum CompressionStrategy {
        SPEED,
        COMPRESSION;

    }

    public static enum EncodingStrategy {
        SPEED,
        COMPRESSION;

    }

    public static enum WriterVersion {
        ORIGINAL(WriterImplementation.ORC_JAVA, 0),
        HIVE_8732(WriterImplementation.ORC_JAVA, 1),
        HIVE_4243(WriterImplementation.ORC_JAVA, 2),
        HIVE_12055(WriterImplementation.ORC_JAVA, 3),
        HIVE_13083(WriterImplementation.ORC_JAVA, 4),
        ORC_101(WriterImplementation.ORC_JAVA, 5),
        ORC_135(WriterImplementation.ORC_JAVA, 6),
        ORC_517(WriterImplementation.ORC_JAVA, 7),
        ORC_203(WriterImplementation.ORC_JAVA, 8),
        ORC_14(WriterImplementation.ORC_JAVA, 9),
        ORC_CPP_ORIGINAL(WriterImplementation.ORC_CPP, 6),
        PRESTO_ORIGINAL(WriterImplementation.PRESTO, 6),
        SCRITCHLEY_GO_ORIGINAL(WriterImplementation.SCRITCHLEY_GO, 6),
        TRINO_ORIGINAL(WriterImplementation.TRINO, 6),
        FUTURE(WriterImplementation.UNKNOWN, Integer.MAX_VALUE);

        private final int id;
        private final WriterImplementation writer;
        private static final WriterVersion[][] values;

        public WriterImplementation getWriterImplementation() {
            return this.writer;
        }

        public int getId() {
            return this.id;
        }

        private WriterVersion(WriterImplementation writer, int id) {
            this.writer = writer;
            this.id = id;
        }

        public static WriterVersion from(WriterImplementation writer, int val) {
            if (writer == WriterImplementation.UNKNOWN) {
                return FUTURE;
            }
            if (writer != WriterImplementation.ORC_JAVA && val < 6) {
                throw new IllegalArgumentException("ORC File with illegal version " + val + " for writer " + (Object)((Object)writer));
            }
            WriterVersion[] versions = values[writer.id];
            if (val < 0 || versions.length <= val) {
                return FUTURE;
            }
            WriterVersion result = versions[val];
            return result == null ? FUTURE : result;
        }

        public boolean includes(WriterVersion fix) {
            return this.writer != fix.writer || this.id >= fix.id;
        }

        static {
            values = new WriterVersion[WriterImplementation.values().length][];
            for (WriterVersion v : WriterVersion.values()) {
                WriterImplementation writer = v.writer;
                if (writer == WriterImplementation.UNKNOWN) continue;
                if (values[writer.id] == null) {
                    WriterVersion.values[((WriterImplementation)writer).id] = new WriterVersion[WriterVersion.values().length];
                }
                if (values[writer.id][v.id] != null) {
                    throw new IllegalArgumentException("Duplicate WriterVersion id " + (Object)((Object)v));
                }
                WriterVersion.values[((WriterImplementation)writer).id][v.id] = v;
            }
        }
    }

    public static enum WriterImplementation {
        ORC_JAVA(0),
        ORC_CPP(1),
        PRESTO(2),
        SCRITCHLEY_GO(3),
        TRINO(4),
        UNKNOWN(Integer.MAX_VALUE);

        private final int id;

        private WriterImplementation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static WriterImplementation from(int id) {
            WriterImplementation[] values = WriterImplementation.values();
            if (id >= 0 && id < values.length - 1) {
                return values[id];
            }
            return UNKNOWN;
        }
    }

    public static enum Version {
        V_0_11("0.11", 0, 11),
        V_0_12("0.12", 0, 12),
        UNSTABLE_PRE_2_0("UNSTABLE-PRE-2.0", 1, 9999),
        FUTURE("future", Integer.MAX_VALUE, Integer.MAX_VALUE);

        public static final Version CURRENT;
        private final String name;
        private final int major;
        private final int minor;

        private Version(String name, int major, int minor) {
            this.name = name;
            this.major = major;
            this.minor = minor;
        }

        public static Version byName(String name) {
            for (Version version : Version.values()) {
                if (!version.name.equals(name)) continue;
                return version;
            }
            throw new IllegalArgumentException("Unknown ORC version " + name);
        }

        public String getName() {
            return this.name;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        static {
            CURRENT = V_0_12;
        }
    }
}

