/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaBinaryPackedReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedValuesReader;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.DataTypes;

public class VectorizedDeltaLengthByteArrayReader
extends VectorizedReaderBase
implements VectorizedValuesReader {
    private final VectorizedDeltaBinaryPackedReader lengthReader = new VectorizedDeltaBinaryPackedReader();
    private ByteBufferInputStream in;
    private WritableColumnVector lengthsVector;
    private int currentRow = 0;

    VectorizedDeltaLengthByteArrayReader() {
    }

    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        this.lengthsVector = new OnHeapColumnVector(valueCount, DataTypes.IntegerType);
        this.lengthReader.initFromPage(valueCount, in);
        this.lengthReader.readIntegers(this.lengthReader.getTotalValueCount(), this.lengthsVector, 0);
        this.in = in.remainingStream();
    }

    @Override
    public void readBinary(int total, WritableColumnVector c, int rowId) {
        VectorizedValuesReader.ByteBufferOutputWriter outputWriter = VectorizedValuesReader.ByteBufferOutputWriter::writeArrayByteBuffer;
        for (int i = 0; i < total; ++i) {
            ByteBuffer buffer;
            int length = this.lengthsVector.getInt(rowId + i);
            try {
                buffer = this.in.slice(length);
            }
            catch (EOFException e) {
                throw new ParquetDecodingException("Failed to read " + length + " bytes");
            }
            outputWriter.write(c, rowId + i, buffer, length);
        }
        this.currentRow += total;
    }

    public ByteBuffer getBytes(int rowId) {
        int length = this.lengthsVector.getInt(rowId);
        try {
            return this.in.slice(length);
        }
        catch (EOFException e) {
            throw new ParquetDecodingException("Failed to read " + length + " bytes");
        }
    }

    @Override
    public void skipBinary(int total) {
        for (int i = 0; i < total; ++i) {
            int remaining = this.lengthsVector.getInt(this.currentRow + i);
            while (remaining > 0) {
                remaining = (int)((long)remaining - this.in.skip((long)remaining));
            }
        }
        this.currentRow += total;
    }
}

