/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

class ConstantColumnVector
extends ColumnVector {
    private final Object constant;
    private final int batchSize;

    ConstantColumnVector(Type type, int batchSize, Object constant) {
        super(SparkSchemaUtil.convert(type));
        this.constant = constant;
        this.batchSize = batchSize;
    }

    public void close() {
    }

    public boolean hasNull() {
        return this.constant == null;
    }

    public int numNulls() {
        return this.constant == null ? this.batchSize : 0;
    }

    public boolean isNullAt(int rowId) {
        return this.constant == null;
    }

    public boolean getBoolean(int rowId) {
        return (Boolean)this.constant;
    }

    public byte getByte(int rowId) {
        return (Byte)this.constant;
    }

    public short getShort(int rowId) {
        return (Short)this.constant;
    }

    public int getInt(int rowId) {
        return (Integer)this.constant;
    }

    public long getLong(int rowId) {
        return (Long)this.constant;
    }

    public float getFloat(int rowId) {
        return ((Float)this.constant).floatValue();
    }

    public double getDouble(int rowId) {
        return (Double)this.constant;
    }

    public ColumnarArray getArray(int rowId) {
        throw new UnsupportedOperationException("ConstantColumnVector only supports primitives");
    }

    public ColumnarMap getMap(int ordinal) {
        throw new UnsupportedOperationException("ConstantColumnVector only supports primitives");
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        return (Decimal)this.constant;
    }

    public UTF8String getUTF8String(int rowId) {
        return (UTF8String)this.constant;
    }

    public byte[] getBinary(int rowId) {
        return (byte[])this.constant;
    }

    public ColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("ConstantColumnVector only supports primitives");
    }
}

