/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;

@InterfaceAudience.Public
@InterfaceStability.Evolving
@XmlRootElement(name="appAttempt")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppAttemptInfo {
    protected String appAttemptId;
    protected String host;
    protected int rpcPort;
    protected String trackingUrl;
    protected String originalTrackingUrl;
    protected String diagnosticsInfo;
    protected YarnApplicationAttemptState appAttemptState;
    protected String amContainerId;
    protected long startedTime;
    protected long finishedTime;

    public AppAttemptInfo() {
    }

    public AppAttemptInfo(ApplicationAttemptReport appAttempt) {
        this.appAttemptId = appAttempt.getApplicationAttemptId().toString();
        this.host = appAttempt.getHost();
        this.rpcPort = appAttempt.getRpcPort();
        this.trackingUrl = appAttempt.getTrackingUrl();
        this.originalTrackingUrl = appAttempt.getOriginalTrackingUrl();
        this.diagnosticsInfo = appAttempt.getDiagnostics();
        this.appAttemptState = appAttempt.getYarnApplicationAttemptState();
        if (appAttempt.getAMContainerId() != null) {
            this.amContainerId = appAttempt.getAMContainerId().toString();
        }
        this.startedTime = appAttempt.getStartTime();
        this.finishedTime = appAttempt.getFinishTime();
    }

    public String getAppAttemptId() {
        return this.appAttemptId;
    }

    public String getHost() {
        return this.host;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public String getOriginalTrackingUrl() {
        return this.originalTrackingUrl;
    }

    public String getDiagnosticsInfo() {
        return this.diagnosticsInfo;
    }

    public YarnApplicationAttemptState getAppAttemptState() {
        return this.appAttemptState;
    }

    public String getAmContainerId() {
        return this.amContainerId;
    }

    public long getStartedTime() {
        return this.startedTime;
    }

    public long getFinishedTime() {
        return this.finishedTime;
    }
}

