/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.co;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.SimpleTimerService;
import org.apache.flink.streaming.api.TimeDomain;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.functions.co.KeyedCoProcessFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
public class KeyedCoProcessOperator<K, IN1, IN2, OUT>
extends AbstractUdfStreamOperator<OUT, KeyedCoProcessFunction<K, IN1, IN2, OUT>>
implements TwoInputStreamOperator<IN1, IN2, OUT>,
Triggerable<K, VoidNamespace> {
    private static final long serialVersionUID = 1L;
    private transient TimestampedCollector<OUT> collector;
    private transient ContextImpl<K, IN1, IN2, OUT> context;
    private transient OnTimerContextImpl<K, IN1, IN2, OUT> onTimerContext;

    public KeyedCoProcessOperator(KeyedCoProcessFunction<K, IN1, IN2, OUT> keyedCoProcessFunction) {
        super(keyedCoProcessFunction);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        InternalTimerService<VoidNamespace> internalTimerService = this.getInternalTimerService("user-timers", VoidNamespaceSerializer.INSTANCE, this);
        SimpleTimerService timerService = new SimpleTimerService(internalTimerService);
        this.context = new ContextImpl((KeyedCoProcessFunction)this.userFunction, timerService);
        this.onTimerContext = new OnTimerContextImpl((KeyedCoProcessFunction)this.userFunction, timerService);
    }

    @Override
    public void processElement1(StreamRecord<IN1> element) throws Exception {
        this.collector.setTimestamp(element);
        ((ContextImpl)this.context).element = element;
        ((KeyedCoProcessFunction)this.userFunction).processElement1(element.getValue(), this.context, this.collector);
        ((ContextImpl)this.context).element = null;
    }

    @Override
    public void processElement2(StreamRecord<IN2> element) throws Exception {
        this.collector.setTimestamp(element);
        ((ContextImpl)this.context).element = element;
        ((KeyedCoProcessFunction)this.userFunction).processElement2(element.getValue(), this.context, this.collector);
        ((ContextImpl)this.context).element = null;
    }

    @Override
    public void onEventTime(InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.collector.setAbsoluteTimestamp(timer.getTimestamp());
        ((OnTimerContextImpl)this.onTimerContext).timeDomain = TimeDomain.EVENT_TIME;
        ((OnTimerContextImpl)this.onTimerContext).timer = timer;
        ((KeyedCoProcessFunction)this.userFunction).onTimer(timer.getTimestamp(), this.onTimerContext, this.collector);
        ((OnTimerContextImpl)this.onTimerContext).timeDomain = null;
        ((OnTimerContextImpl)this.onTimerContext).timer = null;
    }

    @Override
    public void onProcessingTime(InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.collector.eraseTimestamp();
        ((OnTimerContextImpl)this.onTimerContext).timeDomain = TimeDomain.PROCESSING_TIME;
        ((OnTimerContextImpl)this.onTimerContext).timer = timer;
        ((KeyedCoProcessFunction)this.userFunction).onTimer(timer.getTimestamp(), this.onTimerContext, this.collector);
        ((OnTimerContextImpl)this.onTimerContext).timeDomain = null;
        ((OnTimerContextImpl)this.onTimerContext).timer = null;
    }

    protected TimestampedCollector<OUT> getCollector() {
        return this.collector;
    }

    private class OnTimerContextImpl<K, IN1, IN2, OUT>
    extends KeyedCoProcessFunction.OnTimerContext {
        private final TimerService timerService;
        private TimeDomain timeDomain;
        private InternalTimer<K, VoidNamespace> timer;

        OnTimerContextImpl(KeyedCoProcessFunction<K, IN1, IN2, OUT> function, TimerService timerService) {
            super(function);
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
        }

        @Override
        public Long timestamp() {
            Preconditions.checkState((this.timer != null ? 1 : 0) != 0);
            return this.timer.getTimestamp();
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            if (outputTag == null) {
                throw new IllegalArgumentException("OutputTag must not be null.");
            }
            KeyedCoProcessOperator.this.output.collect(outputTag, new StreamRecord<X>(value, this.timer.getTimestamp()));
        }

        @Override
        public TimeDomain timeDomain() {
            Preconditions.checkState((this.timeDomain != null ? 1 : 0) != 0);
            return this.timeDomain;
        }

        @Override
        public K getCurrentKey() {
            return this.timer.getKey();
        }
    }

    private class ContextImpl<K, IN1, IN2, OUT>
    extends KeyedCoProcessFunction.Context {
        private final TimerService timerService;
        private StreamRecord<?> element;

        ContextImpl(KeyedCoProcessFunction<K, IN1, IN2, OUT> function, TimerService timerService) {
            super(function);
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
        }

        @Override
        public Long timestamp() {
            Preconditions.checkState((this.element != null ? 1 : 0) != 0);
            if (this.element.hasTimestamp()) {
                return this.element.getTimestamp();
            }
            return null;
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            if (outputTag == null) {
                throw new IllegalArgumentException("OutputTag must not be null.");
            }
            KeyedCoProcessOperator.this.output.collect(outputTag, new StreamRecord<X>(value, this.element.getTimestamp()));
        }

        @Override
        public K getCurrentKey() {
            return (K)KeyedCoProcessOperator.this.getCurrentKey();
        }
    }
}

