/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.net.URL;
import java.util.function.Consumer;
import org.apache.flink.util.MutableURLClassLoader;

public abstract class FlinkUserCodeClassLoader
extends MutableURLClassLoader {
    public static final Consumer<Throwable> NOOP_EXCEPTION_HANDLER = classLoadingException -> {};
    protected final Consumer<Throwable> classLoadingExceptionHandler;

    protected FlinkUserCodeClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, NOOP_EXCEPTION_HANDLER);
    }

    protected FlinkUserCodeClassLoader(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler) {
        super(urls, parent);
        this.classLoadingExceptionHandler = classLoadingExceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                return this.loadClassWithoutExceptionHandling(name, resolve);
            }
        }
        catch (Throwable classLoadingException) {
            this.classLoadingExceptionHandler.accept(classLoadingException);
            throw classLoadingException;
        }
    }

    protected Class<?> loadClassWithoutExceptionHandling(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

