/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BlueprintRunState {
    RUNNING("RUNNING"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    ROLLING_BACK("ROLLING_BACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BlueprintRunState> VALUE_MAP;
    private final String value;

    private BlueprintRunState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlueprintRunState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlueprintRunState> knownValues() {
        EnumSet<BlueprintRunState> knownValues = EnumSet.allOf(BlueprintRunState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BlueprintRunState.class, BlueprintRunState::toString);
    }
}

