/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.WorkflowRunPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartWorkflowRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, StartWorkflowRunRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartWorkflowRunRequest.getter(StartWorkflowRunRequest::name)).setter(StartWorkflowRunRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> RUN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RunProperties").getter(StartWorkflowRunRequest.getter(StartWorkflowRunRequest::runProperties)).setter(StartWorkflowRunRequest.setter(Builder::runProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RUN_PROPERTIES_FIELD));
    private final String name;
    private final Map<String, String> runProperties;

    private StartWorkflowRunRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.runProperties = builder.runProperties;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRunProperties() {
        return this.runProperties != null && !(this.runProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> runProperties() {
        return this.runProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRunProperties() ? this.runProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWorkflowRunRequest)) {
            return false;
        }
        StartWorkflowRunRequest other = (StartWorkflowRunRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasRunProperties() == other.hasRunProperties() && Objects.equals(this.runProperties(), other.runProperties());
    }

    public final String toString() {
        return ToString.builder((String)"StartWorkflowRunRequest").add("Name", (Object)this.name()).add("RunProperties", this.hasRunProperties() ? this.runProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RunProperties": {
                return Optional.ofNullable(clazz.cast(this.runProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartWorkflowRunRequest, T> g) {
        return obj -> g.apply((StartWorkflowRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private Map<String, String> runProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartWorkflowRunRequest model) {
            super(model);
            this.name(model.name);
            this.runProperties(model.runProperties);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getRunProperties() {
            if (this.runProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.runProperties;
        }

        public final void setRunProperties(Map<String, String> runProperties) {
            this.runProperties = WorkflowRunPropertiesCopier.copy(runProperties);
        }

        @Override
        public final Builder runProperties(Map<String, String> runProperties) {
            this.runProperties = WorkflowRunPropertiesCopier.copy(runProperties);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartWorkflowRunRequest build() {
            return new StartWorkflowRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartWorkflowRunRequest> {
        public Builder name(String var1);

        public Builder runProperties(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

