/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard;

import io.javalin.plugin.json.JsonMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.amoro.TableFormat;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.jetbrains.annotations.NotNull;

public class JavalinJsonMapper
implements JsonMapper {
    private final ObjectMapper objectMapper;

    public static JavalinJsonMapper createDefaultJsonMapper() {
        ObjectMapper om = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(TableFormat.class, (JsonSerializer)new TableFormat.JsonSerializer());
        module.addDeserializer(TableFormat.class, (JsonDeserializer)new TableFormat.JsonDeserializer());
        om.registerModule((Module)module);
        return new JavalinJsonMapper(om);
    }

    public JavalinJsonMapper(ObjectMapper shadedMapper) {
        this.objectMapper = shadedMapper;
    }

    @NotNull
    public String toJsonString(@NotNull Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public InputStream toJsonStream(@NotNull Object obj) {
        if (obj instanceof String) {
            String result = (String)obj;
            return new ByteArrayInputStream(result.getBytes());
        }
        byte[] string = new byte[]{};
        try {
            string = this.objectMapper.writeValueAsBytes(obj);
            return new ByteArrayInputStream(string);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public <T> T fromJsonString(@NotNull String json, @NotNull Class<T> targetClass) {
        try {
            return (T)this.objectMapper.readValue(json, targetClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public <T> T fromJsonStream(@NotNull InputStream json, @NotNull Class<T> targetClass) {
        try {
            return (T)this.objectMapper.readValue(json, targetClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

