/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Duration;
import javax.sql.DataSource;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceFactory.class);
    private static final String DERBY_INIT_SQL_SCRIPT = "derby/ams-derby-init.sql";
    private static final String MYSQL_INIT_SQL_SCRIPT = "mysql/ams-mysql-init.sql";
    private static final String POSTGRES_INIT_SQL_SCRIPT = "postgres/ams-postgres-init.sql";

    public static DataSource createDataSource(Configurations config) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUrl(config.getString(AmoroManagementConf.DB_CONNECTION_URL));
        dataSource.setDriverClassName(config.getString(AmoroManagementConf.DB_DRIVER_CLASS_NAME));
        String dbType = config.getString(AmoroManagementConf.DB_TYPE);
        if ("mysql".equals(dbType) || "postgres".equals(dbType)) {
            dataSource.setUsername(config.getString(AmoroManagementConf.DB_USER_NAME));
            dataSource.setPassword(config.getString(AmoroManagementConf.DB_PASSWORD));
        }
        dataSource.setDefaultAutoCommit(Boolean.valueOf(false));
        dataSource.setMaxTotal(config.getInteger(AmoroManagementConf.DB_CONNECT_MAX_TOTAL));
        dataSource.setMaxIdle(config.getInteger(AmoroManagementConf.DB_CONNECT_MAX_IDLE));
        dataSource.setMinIdle(0);
        dataSource.setMaxWaitMillis(config.getLong(AmoroManagementConf.DB_CONNECT_MAX_WAIT_MILLIS));
        dataSource.setLogAbandoned(true);
        dataSource.setRemoveAbandonedOnBorrow(true);
        dataSource.setRemoveAbandonedTimeout(60);
        dataSource.setTimeBetweenEvictionRunsMillis(Duration.ofMillis(600000L).toMillis());
        dataSource.setTestOnBorrow(false);
        dataSource.setTestWhileIdle(false);
        dataSource.setMinEvictableIdleTimeMillis(1000L);
        dataSource.setNumTestsPerEvictionRun(3);
        dataSource.setTestOnReturn(false);
        dataSource.setSoftMinEvictableIdleTimeMillis(BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME.toMillis());
        dataSource.setLifo(true);
        DataSourceFactory.createTablesIfNeed((DataSource)dataSource, config);
        return dataSource;
    }

    private static void createTablesIfNeed(DataSource ds, Configurations config) {
        boolean initSchema = config.getBoolean(AmoroManagementConf.DB_AUTO_CREATE_TABLES);
        if (!initSchema) {
            LOG.info("Skip auto create tables due to configuration");
            return;
        }
        String dbTypeConfig = config.getString(AmoroManagementConf.DB_TYPE);
        String query = "";
        LOG.info("Start create tables, database type:{}", (Object)dbTypeConfig);
        try (Connection connection = ds.getConnection();
             Statement statement = connection.createStatement();){
            if ("derby".equals(dbTypeConfig)) {
                query = "SELECT 1 FROM SYS.SYSTABLES WHERE TABLENAME = 'CATALOG_METADATA'";
            } else if ("mysql".equals(dbTypeConfig)) {
                query = String.format("SELECT 1 FROM information_schema.tables WHERE table_schema = '%s' AND table_name = '%s'", connection.getCatalog(), "catalog_metadata");
            } else if ("postgres".equals(dbTypeConfig)) {
                query = String.format("SELECT 1 FROM information_schema.tables WHERE table_schema = %s AND table_name = '%s'", "current_schema()", "catalog_metadata");
            }
            LOG.info("Start check table creation, using query: {}", (Object)query);
            try (ResultSet rs = statement.executeQuery(query);){
                if (!rs.next()) {
                    Path script = Paths.get(DataSourceFactory.getInitSqlScriptPath(dbTypeConfig));
                    LOG.info("Table not exists, start run create tables script file:{}", (Object)script);
                    ScriptRunner runner = new ScriptRunner(connection);
                    runner.runScript((Reader)new InputStreamReader(Files.newInputStream(script, new OpenOption[0]), StandardCharsets.UTF_8));
                    LOG.info("Tables are created successfully");
                } else {
                    LOG.info("Tables are created, skip auto create tables.");
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Create tables failed", e);
        }
    }

    private static URI getInitSqlScriptPath(String type) throws URISyntaxException {
        String scriptPath = null;
        if (type.equals("mysql")) {
            scriptPath = MYSQL_INIT_SQL_SCRIPT;
        } else if (type.equals("derby")) {
            scriptPath = DERBY_INIT_SQL_SCRIPT;
        } else if (type.equals("postgres")) {
            scriptPath = POSTGRES_INIT_SQL_SCRIPT;
        }
        URL scriptUrl = ClassLoader.getSystemResource(scriptPath);
        if (scriptUrl == null) {
            throw new IllegalStateException("Cannot find init sql script:" + scriptPath);
        }
        return scriptUrl.toURI();
    }
}

