/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableLongSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableLongEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableLongSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

public class ImmutableLongSetFactoryImpl
implements ImmutableLongSetFactory {
    public static final ImmutableLongSetFactory INSTANCE = new ImmutableLongSetFactoryImpl();

    public ImmutableLongSet empty() {
        return ImmutableLongEmptySet.INSTANCE;
    }

    public ImmutableLongSet of() {
        return this.empty();
    }

    public ImmutableLongSet with() {
        return this.empty();
    }

    public ImmutableLongSet of(long one) {
        return this.with(one);
    }

    public ImmutableLongSet with(long one) {
        return new ImmutableLongSingletonSet(one);
    }

    public ImmutableLongSet of(long ... items) {
        return this.with(items);
    }

    public ImmutableLongSet with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return LongHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableLongSet ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public ImmutableLongSet withAll(LongIterable items) {
        if (items instanceof ImmutableLongSet) {
            return (ImmutableLongSet)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableLongSet ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableLongSet withAll(Iterable<Long> iterable) {
        return LongSets.mutable.withAll(iterable).toImmutable();
    }

    public ImmutableLongSet ofAll(LongStream items) {
        return this.withAll(items);
    }

    public ImmutableLongSet withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

