/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.apache.bifromq.base.util.CascadeCancelCompletableFuture;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeMessage;
import org.apache.bifromq.basekv.proto.StoreMessage;
import org.apache.bifromq.basekv.store.IStoreMessenger;
import org.apache.bifromq.basekv.store.exception.KVRangeException;
import org.apache.bifromq.basekv.store.range.IKVRangeMessenger;

public class KVRangeMessenger
implements IKVRangeMessenger {
    private final String id;
    private final KVRangeId rangeId;
    private final IStoreMessenger messenger;

    public KVRangeMessenger(String id, KVRangeId rangeId, IStoreMessenger messenger) {
        this.id = id;
        this.rangeId = rangeId;
        this.messenger = messenger;
    }

    @Override
    public void send(KVRangeMessage message) {
        this.messenger.send(StoreMessage.newBuilder().setFrom(this.id).setSrcRange(this.rangeId).setPayload(message).build());
    }

    @Override
    public Observable<KVRangeMessage> receive() {
        return this.messenger.receive().mapOptional(storeMessage -> {
            KVRangeMessage payload = storeMessage.getPayload();
            if (!payload.getHostStoreId().equals(this.id) || payload.hasRangeId() && !payload.getRangeId().equals((Object)this.rangeId)) {
                return Optional.empty();
            }
            return Optional.of(payload.toBuilder().setRangeId(storeMessage.getSrcRange()).setHostStoreId(storeMessage.getFrom()).build());
        });
    }

    @Override
    public CompletableFuture<KVRangeMessage> once(Predicate<KVRangeMessage> condition) {
        CompletableFuture onDone = new CompletableFuture();
        Disposable disposable = this.receive().mapOptional(msg -> {
            if (condition.test((KVRangeMessage)msg)) {
                return Optional.of(msg);
            }
            return Optional.empty();
        }).firstElement().subscribe(onDone::complete, e -> onDone.completeExceptionally(new KVRangeException.TryLater("Once test canceled", (Throwable)e)), () -> {
            if (!onDone.isDone()) {
                onDone.completeExceptionally(new KVRangeException.TryLater("Try again"));
            }
        });
        onDone.whenComplete((v, e) -> disposable.dispose());
        return CascadeCancelCompletableFuture.fromRoot(onDone);
    }
}

