/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.PppPacket;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.util.ByteArrays;

public final class PppSelector
extends AbstractPacket {
    private static final long serialVersionUID = -1L;

    public static Packet newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        byte firstByte = rawData[offset];
        PacketFactory<Packet, DataLinkType> factory = PacketFactories.getFactory(Packet.class, DataLinkType.class);
        if (firstByte == -1) {
            return factory.newInstance(rawData, offset, length, DataLinkType.PPP_SERIAL);
        }
        return PppPacket.newPacket(rawData, offset, length);
    }

    private PppSelector() {
        throw new AssertionError();
    }

    @Override
    public Packet.Builder getBuilder() {
        throw new UnsupportedOperationException();
    }
}

