/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.IoUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class ResourceUtils {
    private static final String CLASSPATH_PREFIX = "classpath:";

    private ResourceUtils() {
    }

    public static URL getResourceUrl(String resource) throws IOException {
        if (resource.startsWith(CLASSPATH_PREFIX)) {
            URL url;
            String path = resource.substring(CLASSPATH_PREFIX.length());
            ClassLoader classLoader = ResourceUtils.class.getClassLoader();
            URL uRL = url = classLoader != null ? classLoader.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                throw new FileNotFoundException("Resource [" + resource + "] does not exist");
            }
            return url;
        }
        try {
            return new URL(resource);
        }
        catch (MalformedURLException ex) {
            return new File(resource).toURI().toURL();
        }
    }

    public static URL getResourceUrl(ClassLoader loader, String resource) throws IOException {
        URL url = null;
        if (loader != null) {
            url = loader.getResource(resource);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resource);
        }
        if (url == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resource) throws IOException {
        ClassLoader loader = ResourceUtils.class.getClassLoader();
        return ResourceUtils.getResourceAsStream(loader, resource);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, String resource) throws IOException {
        InputStream in = null;
        if (loader != null) {
            in = loader.getResourceAsStream(resource);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(resource);
        }
        if (in == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return in;
    }

    public static Properties getResourceAsProperties(String resource) throws IOException {
        ClassLoader loader = ResourceUtils.class.getClassLoader();
        return ResourceUtils.getResourceAsProperties(loader, resource);
    }

    public static Properties getResourceAsProperties(ClassLoader loader, String resource) throws IOException {
        Properties props = new Properties();
        InputStream in = ResourceUtils.getResourceAsStream(loader, resource);
        props.load(in);
        IoUtils.closeQuietly((Closeable)in);
        return props;
    }

    public static InputStreamReader getResourceAsReader(String resource, String charsetName) throws IOException {
        return new InputStreamReader(ResourceUtils.getResourceAsStream(resource), charsetName);
    }

    public static Reader getResourceAsReader(ClassLoader loader, String resource, String charsetName) throws IOException {
        return new InputStreamReader(ResourceUtils.getResourceAsStream(loader, resource), charsetName);
    }

    public static File getResourceAsFile(String resource) throws IOException {
        return new File(ResourceUtils.getResourceUrl(resource).getFile());
    }

    public static File getResourceAsFile(URL url) {
        return new File(url.getFile());
    }

    public static File getResourceAsFile(ClassLoader loader, String resource) throws IOException {
        return new File(ResourceUtils.getResourceUrl(loader, resource).getFile());
    }
}

