// Generated by dts-bundle-generator v9.5.1

export type NotificationSeverity = "INFO" | "WARNING" | "ERROR" | "SUCCESS" | "HINT";
export type NotificationType = "PROBLEM" | "ALERT";
interface Notification$1 {
	normalizedPosixPathRelativeToTheWorkspaceRoot: string;
	severity: NotificationSeverity;
	message: string;
	type: NotificationType;
	position?: Position;
}
export interface Position {
	startLineNumber: number;
	startColumn: number;
	endLineNumber: number;
	endColumn: number;
}
declare enum EditorTheme {
	DARK = 0,
	LIGHT = 1,
	HIGH_CONTRAST = 2,
	HIGH_CONTRAST_LIGHT = 3
}
export interface EditorApi {
	setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
	getContent(): Promise<string>;
	getPreview(): Promise<string | undefined>;
	undo(): Promise<void>;
	redo(): Promise<void>;
	validate(): Promise<Notification$1[]>;
	setTheme(theme: EditorTheme): Promise<void>;
}
export interface EditorContent {
	content: string;
	normalizedPosixPathRelativeToTheWorkspaceRoot: string;
	context?: Map<string, string>;
}
export interface ChannelKeyboardEvent {
	altKey: boolean;
	ctrlKey: boolean;
	shiftKey: boolean;
	metaKey: boolean;
	code: string;
	type: string;
	channelOriginalTargetTagName?: string;
}
export interface KeyboardShortcutsEnvelopeApi {
	kogitoKeyboardShortcuts_channelKeyboardEvent(channelKeyboardEvent: ChannelKeyboardEvent): void;
}
export interface I18nEnvelopeApi {
	kogitoI18n_localeChange(locale: string): void;
}
export interface Association {
	origin: string;
	envelopeServerId: string;
}
declare enum ChannelType {
	VSCODE_DESKTOP = "VSCODE_DESKTOP",
	VSCODE_WEB = "VSCODE_WEB",
	ONLINE = "ONLINE",
	GITHUB = "GITHUB",
	EMBEDDED = "EMBEDDED",
	OTHER = "OTHER",
	ONLINE_MULTI_FILE = "ONLINE_MULTI_FILE",
	STANDALONE = "STANDALONE"
}
export interface EditorInitArgs {
	resourcesPathPrefix: string;
	fileExtension: string;
	initialLocale: string;
	isReadOnly: boolean;
	channel: ChannelType;
	workspaceRootAbsolutePosixPath: string;
}
export interface KogitoEditorEnvelopeApi extends KeyboardShortcutsEnvelopeApi, I18nEnvelopeApi {
	kogitoEditor_contentChanged(content: EditorContent, args: {
		showLoadingOverlay: boolean;
	}): Promise<void>;
	kogitoEditor_editorUndo(): void;
	kogitoEditor_editorRedo(): void;
	kogitoEditor_initRequest(association: Association, editorInit: EditorInitArgs): Promise<void>;
	kogitoEditor_contentRequest(): Promise<EditorContent>;
	kogitoEditor_previewRequest(): Promise<string>;
	kogitoEditor_validate(): Promise<Notification$1[]>;
}
export type SharedValueProviderPropertyNames<T extends ApiDefinition<T>> = {
	[K in keyof T]: ReturnType<T[K]> extends SharedValueProvider<any> ? K : never;
}[keyof T];
export type NotificationPropertyNames<T extends ApiDefinition<T>> = {
	[K in keyof T]: ReturnType<T[K]> extends void ? K : never;
}[keyof T];
export type RequestPropertyNames<T extends ApiDefinition<T>> = {
	[K in keyof T]: ReturnType<T[K]> extends Promise<any> ? K : never;
}[keyof T];
export interface SharedValueConsumer<T> {
	subscribe(callback: (newValue: T) => void): (newValue: T) => any;
	unsubscribe(subscription: (newValue: T) => void): void;
	set(t: T): void;
}
export interface SharedValueProvider<T> {
	defaultValue: T;
}
export type ApiDefinition<T> = {
	[P in keyof T]: (...a: any) => Promise<any> | SharedValueProvider<any> | void;
};
export type ArgsType<T> = T extends (...args: infer A) => any ? A : never;
export type ApiRequests<T extends ApiDefinition<T>> = Pick<T, RequestPropertyNames<T>>;
export type ApiNotificationConsumers<T extends ApiDefinition<T>> = Pick<WithNotificationConsumers<T>, NotificationPropertyNames<T>>;
export type ApiSharedValueConsumers<T extends ApiDefinition<T>> = Pick<WithSharedValueConsumers<T>, SharedValueProviderPropertyNames<T>>;
export type WithSharedValueConsumers<T extends ApiDefinition<T>> = {
	[K in keyof T]: ReturnType<T[K]> extends SharedValueProvider<infer U> ? SharedValueConsumer<U> : never;
};
export interface NotificationConsumer<N> {
	subscribe(callback: (...newValue: ArgsType<N>) => void): (...newValue: ArgsType<N>) => any;
	unsubscribe(subscription: (...newValue: ArgsType<N>) => void): void;
	send(...args: ArgsType<N>): void;
}
export type WithNotificationConsumers<T extends ApiDefinition<T>> = {
	[K in keyof T]: ReturnType<T[K]> extends void ? NotificationConsumer<T[K]> : never;
};
export interface MessageBusClientApi<Api extends ApiDefinition<Api>> {
	requests: ApiRequests<Api>;
	notifications: ApiNotificationConsumers<Api>;
	shared: ApiSharedValueConsumers<Api>;
}
export interface Command {
	id: string;
	undo?: () => void;
	redo?: () => void;
}
declare class StateControl {
	private commandStack;
	private currentCommand?;
	private savedCommand?;
	private registeredCallbacks;
	constructor();
	subscribe(callback: (isDirty: boolean) => void): (isDirty: boolean) => void;
	unsubscribe(callback: (isDirty: boolean) => void): void;
	getSavedCommand(): Command | undefined;
	getCurrentCommand(): Command | undefined;
	getCommandStack(): Command[];
	getRegisteredCallbacks(): ((isDirty: boolean) => void)[];
	setSavedCommand(): void;
	private setCurrentCommand;
	isDirty(): boolean;
	undo(): void;
	redo(): void;
	private eraseRedoCommands;
	updateCommandStack(command: Command): void;
}
export interface StandaloneEditorApi extends EditorApi {
	subscribeToContentChanges: StateControl["subscribe"];
	unsubscribeToContentChanges: StateControl["unsubscribe"];
	markAsSaved: StateControl["setSavedCommand"];
	envelopeApi: MessageBusClientApi<KogitoEditorEnvelopeApi>;
	close: () => void;
}
export type EditorStandaloneResource = {
	contentType: "text" | "binary";
	content: Promise<string>;
};
export interface CanvasEditorApi {
	getNodeIds(): Promise<string[]>;
	getBackgroundColor(uuid: string): Promise<string>;
	setBackgroundColor(uuid: string, backgroundColor: string): Promise<void>;
	getBorderColor(uuid: string): Promise<string>;
	setBorderColor(uuid: string, borderColor: string): Promise<void>;
	getLocation(uuid: string): Promise<number[]>;
	getAbsoluteLocation(uuid: string): Promise<number[]>;
	getDimensions(uuid: string): Promise<number[]>;
	applyState(uuid: string, state: string): Promise<void>;
	centerNode(uuid: string): Promise<void>;
}
export interface BpmnEditorDiagramApi {
	canvas: CanvasEditorApi;
}
declare function open$1(args: {
	container: Element;
	initialContent: Promise<string>;
	readOnly?: boolean;
	origin?: string;
	onError?: () => any;
	resources?: Map<string, EditorStandaloneResource>;
}): StandaloneEditorApi & BpmnEditorDiagramApi;

export {
	open$1 as open,
};

export {};
