/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.ozhera.log.manager.model.dto.DictionaryDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogAppMiddlewareRel;
import org.apache.ozhera.log.manager.service.CommonRocketMqService;
import org.apache.ozhera.log.manager.service.MqConfigService;
import org.apache.ozhera.log.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class KafkaMqConfigService
implements MqConfigService,
CommonRocketMqService {
    private static final Logger log = LoggerFactory.getLogger(KafkaMqConfigService.class);
    @Value(value="$kafka.use.ssl")
    private String kafkaUseSsl;
    @Value(value="$kafka.sll.location")
    private String kafkaSllLocation;

    @Override
    public MilogAppMiddlewareRel.Config generateConfig(String ak, String sk, String nameServer, String serviceUrl, String authorization, String orgId, String teamId, Long exceedId, String name, String source, Long id) {
        MilogAppMiddlewareRel.Config config = new MilogAppMiddlewareRel.Config();
        Properties properties = new Properties();
        if (StringUtils.isNotEmpty((CharSequence)ak) && StringUtils.isNotEmpty((CharSequence)sk) && Objects.equals("true", this.kafkaUseSsl)) {
            properties.putAll((Map<?, ?>)KafkaUtils.getSslKafkaProperties((String)nameServer, (String)ak, (String)sk, (String)this.kafkaSllLocation));
        } else if (StringUtils.isNotEmpty((CharSequence)ak) && StringUtils.isNotEmpty((CharSequence)sk)) {
            properties.putAll((Map<?, ?>)KafkaUtils.getVpc9094KafkaProperties((String)nameServer, (String)ak, (String)sk));
        } else {
            properties.putAll((Map<?, ?>)KafkaUtils.getDefaultKafkaProperties((String)nameServer));
        }
        properties.put("bootstrap.servers", nameServer);
        String topicName = this.generateSimpleTopicName(id, name);
        try (AdminClient adminClient = AdminClient.create((Properties)properties);){
            List topics = Lists.newArrayList((Object[])new String[]{topicName}).stream().map(topic -> new NewTopic(topic, Optional.of(1), Optional.of((short)1))).collect(Collectors.toList());
            CreateTopicsResult result = adminClient.createTopics(topics);
            Map values = result.values();
            for (Map.Entry entry : values.entrySet()) {
                try {
                    ((KafkaFuture)entry.getValue()).get();
                    log.info("Topic:{},created successfully.", entry.getKey());
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error("Failed to create topic:{}", entry.getKey(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("create kafka topic error,topic:{}", (Object)topicName, (Object)e);
        }
        config.setTopic(topicName);
        config.setPartitionCnt(1);
        return config;
    }

    @Override
    public List<DictionaryDTO> queryExistsTopic(String ak, String sk, String nameServer, String serviceUrl, String authorization, String orgId, String teamId) {
        List<DictionaryDTO> list;
        block12: {
            Properties properties = new Properties();
            if (StringUtils.isNotEmpty((CharSequence)ak) && StringUtils.isNotEmpty((CharSequence)sk) && Objects.equals("true", this.kafkaUseSsl)) {
                properties.putAll((Map<?, ?>)KafkaUtils.getSslKafkaProperties((String)nameServer, (String)ak, (String)sk, (String)this.kafkaSllLocation));
            } else if (StringUtils.isNotEmpty((CharSequence)ak) && StringUtils.isNotEmpty((CharSequence)sk)) {
                properties.putAll((Map<?, ?>)KafkaUtils.getVpc9094KafkaProperties((String)nameServer, (String)ak, (String)sk));
            } else {
                properties.putAll((Map<?, ?>)KafkaUtils.getDefaultKafkaProperties((String)nameServer));
            }
            properties.put("bootstrap.servers", nameServer);
            AdminClient adminClient = AdminClient.create((Properties)properties);
            try {
                Set<String> topics = KafkaMqConfigService.getTopicList(adminClient);
                list = topics.stream().map(data -> {
                    DictionaryDTO<String> dictionaryDTO = new DictionaryDTO<String>();
                    dictionaryDTO.setLabel((String)data);
                    dictionaryDTO.setValue((String)data);
                    return dictionaryDTO;
                }).collect(Collectors.toList());
                if (adminClient == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("query kafka topic list error", (Throwable)e);
                    return null;
                }
            }
            adminClient.close();
        }
        return list;
    }

    private static Set<String> getTopicList(AdminClient adminClient) throws ExecutionException, InterruptedException {
        ListTopicsOptions options = new ListTopicsOptions();
        options.listInternal(true);
        ListTopicsResult topicsResult = adminClient.listTopics(options);
        return (Set)topicsResult.names().get();
    }

    @Override
    public List<String> createCommonTagTopic(String ak, String sk, String nameServer, String serviceUrl, String authorization, String orgId, String teamId) {
        return null;
    }

    @Override
    public boolean CreateGroup(String ak, String sk, String nameServer) {
        return false;
    }
}

